/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/view/control/alignmentpicker', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/control/radiolist',
    'io.ox/office/spreadsheet/view/labels',
    'gettext!io.ox/office/spreadsheet'
], function (Utils, RadioList, Labels, gt) {

    'use strict';

    var // control settings for horizontal orientation
        HORIZONTAL_ALIGNMENT_STYLES = {
            initOptions: {
                icon: 'docs-para-align-left',
                tooltip: /*#. text alignment in cells */ gt('Horizontal alignment'),
                updateCaptionMode: 'icon',
                dropDownVersion: {
                    label: gt('Horizontal alignment')
                }
            },
            labels: Labels.HOR_ALIGNMENT_LABELS,
            entries: [
                { value: 'auto',    icon: 'docs-cell-h-align-auto' },
                { value: 'left',    icon: 'docs-cell-h-align-left' },
                { value: 'center',  icon: 'docs-cell-h-align-center' },
                { value: 'right',   icon: 'docs-cell-h-align-right' },
                { value: 'justify', icon: 'docs-cell-h-align-justify' }
            ]
        },

        // control settings for vertical orientation
        VERTICAL_ALIGNMENT_STYLES = {
            initOptions: {
                icon: 'docs-cell-vertical-bottom',
                tooltip: /*#. text alignment in cells */ gt('Vertical alignment'),
                updateCaptionMode: 'icon',
                dropDownVersion: {
                    label: gt('Vertical alignment')
                }
            },
            labels: Labels.VERT_ALIGNMENT_LABELS,
            entries: [
                { value: 'top',     icon: 'docs-cell-v-align-top' },
                { value: 'middle',  icon: 'docs-cell-v-align-middle' },
                { value: 'bottom',  icon: 'docs-cell-v-align-bottom' },
                { value: 'justify', icon: 'docs-cell-v-align-justify' }
            ]
        };

    // class AlignmentPicker ==================================================

    /**
     * A picker control for horizontal or vertical cell alignment.
     *
     * @constructor
     *
     * @extends RadioList
     *
     * @param {String} orientation
     *  The orientation of the alignment represented by the control. Must be
     *  one of 'horizontal' or 'vertical'.
     */
    function AlignmentPicker(orientation, initOptions) {

        var // the settings for this control, according to orientation
            config = (function () {
                switch (orientation) {
                case 'horizontal':
                    return HORIZONTAL_ALIGNMENT_STYLES;
                case 'vertical':
                    return VERTICAL_ALIGNMENT_STYLES;
                }
            }());

        // base constructor ---------------------------------------------------

        RadioList.call(this, Utils.extendOptions(config.initOptions, initOptions));

        // initialization -----------------------------------------------------

        _.each(config.entries, function (entryData) {
            this.createOptionButton(entryData.value, { icon: entryData.icon, label: config.labels[entryData.value] });
        }, this);

    } // class AlignmentPicker

    // exports ================================================================

    // derive this class from class RadioList
    return RadioList.extend({ constructor: AlignmentPicker });

});
