/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/utils/operations', [
    'io.ox/office/editframework/utils/operations'
], function (EditOperations) {

    'use strict';

    // static class SpreadsheetOperations =====================================

    /**
     * Provides constants for the names of all document operations used in
     * spreadsheet documents.
     *
     * @extends EditOperations
     */
    var SpreadsheetOperations = _.extend(EditOperations, {

        INSERT_SHEET: 'insertSheet',
        DELETE_SHEET: 'deleteSheet',
        MOVE_SHEET: 'moveSheet',
        COPY_SHEET: 'copySheet',

        SET_SHEET_NAME: 'setSheetName',
        SET_SHEET_ATTRIBUTES: 'setSheetAttributes',

        INSERT_NAME: 'insertName',
        CHANGE_NAME: 'changeName',
        DELETE_NAME: 'deleteName',

        INSERT_TABLE: 'insertTable',
        CHANGE_TABLE: 'changeTable',
        DELETE_TABLE: 'deleteTable',
        CHANGE_TABLE_COLUMN: 'changeTableColumn',

        INSERT_VALIDATION: 'insertValidation',
        CHANGE_VALIDATION: 'changeValidation',
        DELETE_VALIDATION: 'deleteValidation',

        INSERT_COLUMNS: 'insertColumns',
        DELETE_COLUMNS: 'deleteColumns',
        SET_COLUMN_ATTRIBUTES: 'setColumnAttributes',

        INSERT_ROWS: 'insertRows',
        DELETE_ROWS: 'deleteRows',
        SET_ROW_ATTRIBUTES: 'setRowAttributes',

        INSERT_CELLS: 'insertCells',
        DELETE_CELLS: 'deleteCells',
        MERGE_CELLS: 'mergeCells',

        SET_CELL_CONTENTS: 'setCellContents',
        FILL_CELL_RANGE: 'fillCellRange',
        CLEAR_CELL_RANGE: 'clearCellRange',
        AUTO_FILL: 'autoFill'

    });

    // exports ================================================================

    return SpreadsheetOperations;

});
