/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/utils/config', [
    'io.ox/office/tk/utils',
    'io.ox/office/editframework/utils/editconfig',
    'settings!io.ox/office'
], function (Utils, EditConfig, settings) {

    'use strict';

    var // the configuration items of the spreadsheet module
        moduleConfig = settings.get('spreadsheet', {});

    // static class SpreadsheetConfig =========================================

    var SpreadsheetConfig = _.clone(EditConfig);

    /**
     * The configured maximum number of non-empty cells allowed to be contained
     * in a complete spreadsheet document.
     *
     * @constant
     */
    SpreadsheetConfig.MAX_CELL_COUNT = Utils.getIntegerOption(moduleConfig, 'maxCells', 500000);

    /**
     * The configured maximum number of sheets allowed to be contained in a
     * spreadsheet document.
     *
     * @constant
     */
    SpreadsheetConfig.MAX_SHEET_COUNT = Utils.getIntegerOption(moduleConfig, 'maxSheets', 256);

    // exports ================================================================

    return SpreadsheetConfig;

});
