/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/view/editcontrols', [
    'io.ox/office/tk/utils',
    'io.ox/office/baseframework/view/basecontrols',
    'io.ox/office/drawinglayer/view/drawingcontrols',
    'io.ox/office/editframework/view/control/applicationstatuslabel',
    'io.ox/office/editframework/view/control/acquireeditbutton',
    'io.ox/office/editframework/view/control/filenamefield',
    'io.ox/office/editframework/view/control/colorpicker',
    'io.ox/office/editframework/view/control/bordermodepicker',
    'io.ox/office/editframework/view/control/borderstylepicker',
    'io.ox/office/editframework/view/control/borderwidthpicker',
    'io.ox/office/editframework/view/control/fontfamilypicker',
    'io.ox/office/editframework/view/control/fontsizepicker',
    'io.ox/office/editframework/view/control/stylesheetpicker',
    'io.ox/office/editframework/view/control/languagepicker',
    'io.ox/office/editframework/view/control/tablesizepicker',
    'io.ox/office/editframework/view/control/userbadge',
    'io.ox/office/editframework/view/control/toolbartabgroup',
    'io.ox/office/editframework/view/control/toolbartablist',
    'gettext!io.ox/office/editframework'
], function (Utils, BaseControls, DrawingControls, ApplicationStatusLabel, AcquireEditButton, FileNameField, ColorPicker, BorderModePicker, BorderStylePicker, BorderWidthPicker, FontFamilyPicker, FontSizePicker, StyleSheetPicker, LanguagePicker, TableSizePicker, UserBadge, ToolBarTabGroup, ToolBarTabList, gt) {

    'use strict';

    // static class EditControls ==============================================

    /**
     * Provides different classes for GUI form controls. Collects all standard
     * control group classes defined in the toolkit, and adds more controls in
     * a single map for convenience.
     *
     * @extends BaseControls
     * @extends DrawingControls
     */
    var EditControls = _.extend({}, BaseControls, DrawingControls, {
        ApplicationStatusLabel: ApplicationStatusLabel,
        AcquireEditButton: AcquireEditButton,
        FileNameField: FileNameField,
        ColorPicker: ColorPicker,
        BorderModePicker: BorderModePicker,
        BorderStylePicker: BorderStylePicker,
        BorderWidthPicker: BorderWidthPicker,
        FontFamilyPicker: FontFamilyPicker,
        FontSizePicker: FontSizePicker,
        StyleSheetPicker: StyleSheetPicker,
        LanguagePicker: LanguagePicker,
        TableSizePicker: TableSizePicker,
        UserBadge: UserBadge,
        ToolBarTabGroup: ToolBarTabGroup,
        ToolBarTabList: ToolBarTabList
    });

    // class TextColorPicker ==================================================

    /**
     * A color picker control for selecting a text color. The list entry for
     * the automatic color will be shown as 'Black'.
     *
     * @constructor
     *
     * @extends ColorPicker
     */
   EditControls.TextColorPicker = ColorPicker.extend({ constructor: function (app, initOptions) {

       ColorPicker.call(this, app, 'text', Utils.extendOptions({
           icon: 'docs-font-color',
           tooltip: gt('Text color')
       }, initOptions));

   }}); // class TextColorPicker

     // class FillColorPicker ==================================================

     /**
      * A color picker control for selecting a fill color. The list entry for
     * the automatic color will be shown as 'No fill'.
      *
      * @constructor
      *
      * @extends ColorPicker
      */
    EditControls.FillColorPicker = ColorPicker.extend({ constructor: function (app, initOptions) {

        ColorPicker.call(this, app, 'fill', Utils.extendOptions({
            icon: 'docs-cell-fill-color',
            tooltip: gt('Fill color')
        }, initOptions));

    }}); // class FillColorPicker

    // class BorderColorPicker ==================================================

     /**
      * A color picker control for selecting a border color. The list entry for
     * the automatic color will be shown as 'Black'.
      *
      * @constructor
      *
      * @extends ColorPicker
      */
    EditControls.BorderColorPicker = ColorPicker.extend({ constructor: function (app, initOptions) {

        ColorPicker.call(this, app, null, Utils.extendOptions({
            icon: 'docs-drawing-line-color',
            tooltip: gt.pgettext('borders', 'Border color'),
            showAutoColor: false
        }, initOptions));

    }}); // class BorderColorPicker

    // class AccessRightsPicker ===============================================

    EditControls.AccessRightsPicker = BaseControls.RadioList.extend({ constructor: function (app, initOptions) {

        BaseControls.RadioList.call(this, Utils.extendOptions(initOptions, {
            label: _.noI18n('Access Rights'),
            sortItems: true
        }));

        _.times(4, function (index) {
            var mail = 'user' + (index + 1) + '@example.com';
            this.createOptionButton(mail, { label: _.noI18n('User ' + (index + 1)), tooltip: _.noI18n(mail) });
        }, this);

    }}); // class AccessRightsPicker

    // exports ================================================================

    return EditControls;

});
