/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/view/control/toolbartablist',
    ['io.ox/office/tk/utils',
     'io.ox/office/tk/forms',
     'io.ox/office/tk/control/radiolist',
     'gettext!io.ox/office/editframework'
    ], function (Utils, Forms, RadioList, gt) {

    'use strict';

    // class ToolBarTabList ===================================================

    /**
     * @constructor
     *
     * @extends RadioList
     */
    function ToolBarTabList(app, toolBarTabs) {

        var // self reference
            self = this;

        // base constructor ---------------------------------------------------

        RadioList.call(this, {
            label: /*#. title for a drop-down selector for tool bars (on small devices) */ gt('Toolbars'),
            tooltip: /*#. tool tip for a drop-down selector for tool bars (on small devices) */ gt('Select a toolbar'),
            width: 150,
            highlight: true,
            smallerVersion: {
                css: { width: 20 },
                icon: 'fa-bars',
                hideLabel: true
            }
        });

        // private methods ----------------------------------------------------

        function tabCreateHandler(event, tabId, options) {
            self.createOptionButton(tabId, options);
        }

        function tabLabelHandler(event, tabId, label) {
            Forms.setCaptionText(self.getMenu().findItemNodes(tabId), label);
        }

        // initialization -----------------------------------------------------

        // update control according to the tab collection
        toolBarTabs.on({
            // create button element for a new tab
            'tab:create': tabCreateHandler,
            'tab:label': tabLabelHandler,
            // show/hide tab buttons
            'tab:show': function (event, tabId) { Forms.showNodes(self.getMenu().findItemNodes(tabId), true); },
            'tab:hide': function (event, tabId) { Forms.showNodes(self.getMenu().findItemNodes(tabId), false); },
            // update selected button
            'tab:activate': function (event, tabId) { self.setValue(tabId); }
        });

    } // class ToolBarTabList

    // exports ================================================================

    // derive this class from class RadioList
    return RadioList.extend({ constructor: ToolBarTabList });

});
