/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/view/control/acquireeditbutton', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/control/button',
    'io.ox/office/editframework/view/editlabels',
    'gettext!io.ox/office/editframework'
], function (Utils, Button, Labels, gt) {

    'use strict';

    // class AcquireEditButton ================================================

    /**
     * A button used to acquire edit rights for the document.
     *
     * @constructor
     *
     * @extends Button
     */
    function AcquireEditButton(app, initOptions) {

        var // self reference
            self = this,

            // timer that stops the animation after a delay
            timer = null;

        // base constructor ---------------------------------------------------

        initOptions = Utils.extendOptions({
            icon: Labels.EDIT_ICON,
            label: Labels.EDIT_SHORT_LABEL,
            tooltip: gt('Acquire edit rights'),
            smallerVersion: { hideLabel: true }
        }, initOptions);
        Button.call(this, initOptions);

        // private methods ----------------------------------------------------

        /**
         * Starts the spinning animation while edit rights are being acquired.
         */
        function startAnimation() {
            stopAnimation();
            self.setIcon('fa-refresh', { classes: 'fa-spin' });
            timer = self.executeDelayed(stopAnimation, 30000);
        }

        /**
         * Stops the spinning animation shown while edit rights are being
         * acquired.
         */
        function stopAnimation() {
            if (timer) { timer.abort(); timer = null; }
            self.setIcon(initOptions.icon);
        }

        // initialization -----------------------------------------------------

        // start and stop the spinning animation
        app.onInit(function () {
            self.listenTo(app, 'docs:editrights:acquire', startAnimation);
            self.listenTo(app, 'docs:editrights:decline', stopAnimation);
            self.listenTo(app.getModel(), 'change:editmode', stopAnimation);
        });

        // destroy class members on destruction
        this.registerDestructor(function () {
            stopAnimation();
            app = initOptions = self = null;
        });

    } // class AcquireEditButton

    // exports ================================================================

    // derive this class from class Button
    return Button.extend({ constructor: AcquireEditButton });

});
