/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH.
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/utils/editconfig', ['io.ox/office/tk/config'], function (Config) {

    'use strict';

    // static class EditConfig ================================================

    var EditConfig = _.clone(Config);

    /**
     * A Boolean flag specifying whether the local browser storage will be used
     * for saving documents.
     *
     * @constant
     */
    EditConfig.USE_LOCAL_STORAGE = EditConfig.getFlag('useLocalStorage', true);

    /**
     * A Boolean flag specifying whether the current selection of remote users
     * will be displayed in all OX Documents edit applications.
     *
     * @constant
     */
    EditConfig.SHOW_REMOTE_SELECTIONS = EditConfig.getFlag('showRemoteSelections', true);

    /**
     * A Boolean flag specifying whether detailed performance data will be sent
     * to and logged at the server.
     *
     * @constant
     */
    EditConfig.LOG_PERFORMANCE_DATA = EditConfig.getFlag('logPerformanceData', false);

    /**
     * A Boolean flag specifying whether the error and other important data
     * for bug hunting will be sent to and logged by the server.
     *
     * @constant
     */
    EditConfig.LOG_ERROR_DATA = EditConfig.getFlag('logErrorData', false);
    
    /**
     * A Boolean flag specifying whether the Document Name edit field should enabled or
     * disabled. This ensures that in environments, which don't support transparent
     * changes of the file name, don't break an active RT connection.
     */
    EditConfig.RENAME_DISABLED = EditConfig.getFlag('renamedisabled', false);

    // exports ================================================================

    return EditConfig;

});
