/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define(['io.ox/office/tk/keycodes'], function (KeyCodes) {
    'use strict';

    describe('OX Documents Base Framework', function () {
        describe('KeyCodes module', function () {

            it('should exist', function () {
                expect(KeyCodes).to.be.an('object');
            });

            // constants ======================================================

            // methods ========================================================

            describe('method "matchKeyCode"', function () {
                it('should exist', function () {
                    expect(KeyCodes).itself.to.respondTo('matchKeyCode');
                });
                it('TAB has keycode 9', function () {
                    expect(KeyCodes.matchKeyCode({ keyCode: 9 }, 'TAB')).to.be['true'];
                });
            });

            // ----------------------------------------------------------------

        });
    });
});
