/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/view/control/sortmenubutton', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/control/button',
    'io.ox/office/baseframework/view/control/compoundsplitbutton',
    'gettext!io.ox/office/spreadsheet'
], function (Utils, Button, CompoundSplitButton, gt) {

    'use strict';

    // class SortMenuButton ===================================================

    /**
     * Sorting control in toolbar.
     *
     * @constructor
     *
     * @extends CompoundSplitButton
     */
    function SortMenuButton(app, initOptions) {

        var // self reference
            self = this,

            // the document view
            docView = null;

        // base constructor ---------------------------------------------------

        CompoundSplitButton.call(this, app, Utils.extendOptions({
            icon: 'fa-sort-alpha-asc',
            tooltip: /*#. spreadsheet sorting: button tooltip for sorting */ gt.pgettext('sort', 'Sorting')
        }, initOptions, {
            value: 'toggle',
            updateCaptionMode: 'icon'
        }));

        // private methods ----------------------------------------------------

        /**
         * Updates the icon according to the sort state.
         */
        function updateHandler() {
            switch (docView.getSortState()) {
            case 'ascending':
                self.setIcon('fa-sort-alpha-asc');
                break;
            case 'descending':
                self.setIcon('fa-sort-alpha-desc');
                break;
            case 'custom':
                self.setIcon('fa-cogs');
                break;
            }
        }

        // initialization -----------------------------------------------------

        // initialize class members when application is ready
        app.onInit(function () {
            docView = app.getView();
        });

        // create all drop-down menu items
        this.addGroup('cell/sort', new Button({ icon: 'fa-sort-alpha-asc', label: /*#. sort ascending */ gt.pgettext('sort', 'Ascending'), tooltip: gt.pgettext('sort', 'Sort from smallest to largest value'), value: 'ascending' }))
            .addGroup('cell/sort', new Button({ icon: 'fa-sort-alpha-desc', label: /*#. sort descending */ gt.pgettext('sort', 'Descending'), tooltip: gt.pgettext('sort', 'Sort from largest to smallest value'), value: 'descending' }))
            .addSeparator()
            .addGroup('cell/sort/expanddialog', new Button({ label: /*#. sorting: label of the button opening a menu with custom sort options */ gt.pgettext('sort', 'Custom'), tooltip: /*#. tooltip for custom sort button */ gt.pgettext('sort', 'Settings for sorting') }));

        // update the icon in the drop-down button
        this.registerUpdateHandler(updateHandler);

        // destroy all class members on destruction
        this.registerDestructor(function () {
            app = initOptions = self = docView = null;
        });

    } // class SortMenuButton

    // exports ================================================================

    // derive this class from class CompoundSplitButton
    return CompoundSplitButton.extend({ constructor: SortMenuButton });

});
