/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/formula/complex', function () {

    'use strict';

    // class Complex ==========================================================

    /**
     * Representation of a complex number literal: a data structure with a
     * floating-point property for the real coefficient, and a floating-point
     * property for the imaginary coefficient.
     *
     * @constructor
     *
     * @param {Number} real
     *  The real coefficient. Will be set as public object property 'real'.
     *
     * @param {Number} imag
     *  The imaginary coefficient. Will be set as public object property
     *  'imag'.
     *
     * @param {String} [unit]
     *  The imaginary unit (either 'i' or 'j'). If omitted, the imaginary unit
     *  to be used is undetermined yet (by default, 'i' will be used). Will be
     *  set as public object property 'unit'.
     */
    function Complex(real, imag, unit) {

        this.real = real;
        this.imag = imag;
        this.unit = _.isString(unit) ? unit : null;

    } // class Complex

    // public methods ---------------------------------------------------------

    /**
     * Returns the string representation of this complex number for debug
     * logging.
     */
    Complex.prototype.toString = function () {
        return this.real + ((this.imag >= 0) ? '+' : '') + this.imag + (this.unit || 'i');
    };

    // exports ================================================================

    return Complex;

});
