/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/drawing/axistitlemodel',
    ['io.ox/office/editframework/model/attributedmodel'
    ], function (AttributedModel) {

    'use strict';

    // class AxisTitleModel ===================================================

    /**
     * visualization model for chart axes,
     * it defines colors and textual colors
     */
    function AxisTitleModel(chart) {

        // base constructor ---------------------------------------------------

        AttributedModel.call(this, chart.getApp(), null, { families: 'text character' });

    } // class AxisTitleModel

    // exports ================================================================

    return AttributedModel.extend({ constructor: AxisTitleModel });

});
