/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/settings/register', [
    'io.ox/core/extensions',
    'io.ox/core/manifests',
    'io.ox/office/tk/io',
    'io.ox/office/settings/templatefolders',
    'io.ox/office/settings/templatemodel',
    'io.ox/office/settings/contexttemplatemodel',
    'gettext!io.ox/office/main'
], function (ext, Manifests, IO, TemplateFolders, TemplateModel, ContextTemplateModel, gt) {

    'use strict';

    var inited = false;

    var Register = {};

    Register.init = function (manifestPath) {

        if (inited) {
            return;
        }

        //TODO: this is not the best way!!!
        if (Manifests.manager.isDisabled(manifestPath)) {
            return;
        }

        inited = true;

        //extend the global settings with office settings
        ext.point('io.ox/settings/pane').extend({
            id: 'io.ox/office',
            title: 'Documents',
            ref: 'io.ox/office',
            loadSettingPane: false,
            index: 500
        });

        var settingsObject = {};
        var settingsNode = null;
        var subSettings = [];

        subSettings.push(new TemplateFolders(new TemplateModel('UserTemplateFolders'), { title: gt('My template folders'), useMyFiles: true }));

        checkAdmin().always(function () {
            var resolved = this.state() === 'resolved';
            var model = null;

            var init = function () {
                subSettings.push(new TemplateFolders(model, { title: gt('Global template folders'), readOnly: !resolved, showReadAccess: resolved }));
            };

            if (resolved) {
                model = new TemplateModel('ContextTemplateFolders');
                init();
            } else {
                IO.sendRequest(IO.FILTER_MODULE_NAME, { action: 'getcontexttemplatefolders' }).done(function (data) {
                    model = new ContextTemplateModel(data);
                    init();
                });
            }
        });

        /**
         * standard options section-title
         */
        settingsObject.appendTitle = function (title) {
            var tt = $('<legend class="sectiontitle">');
            tt.text(title);
            settingsNode.append(tt);
        };

        /**
         * standard dialog button
         */
        settingsObject.appendButton = function (title, listener) {
            var btn = $('<button type="button" class="btn btn-primary" tabindex="1">');
            btn.text(title).on('click', listener);
            settingsNode.append(btn);
        };

        settingsObject.append = function (node) {
            settingsNode.append(node);
        };

        var first = true;

        var innerDraw = function () {

            settingsNode = this;

            settingsNode.empty();
            settingsNode.append($('<h1>').text(gt('Documents')));

            _.each(subSettings, function (subSetting) {
                subSetting.refresh(settingsObject);
            });

            if (first) {
                first = false;
                var settingsWindow = ox.ui.windowManager.getWindows().filter(function (win) { return win.name === 'io.ox/settings'; })[0];

                var thizz = this;

                var refresh = function () {
                    settingsWindow.app.folder.getData().done(function (model) {
                        if (model.id === 'virtual/settings/io.ox/office') {
                            innerDraw.apply(thizz, arguments);
                        }
                    });
                };

                ox.on('refresh^', refresh);
                settingsWindow.on('beforeshow', refresh);
            }
        };

        function checkAdmin() {
            var resp = $.ajax('/ajax/user/me?session=' + ox.session, {
                type: 'GET',
                dataType: 'json'
            });
            var ret = $.Deferred();
            resp.done(function (answer) {
                if (answer.data.user_id && answer.data.user_id === answer.data.context_admin) {
                    ret.resolve();
                } else {
                    ret.reject();
                }
            });
            resp.fail(ret.reject);
            return ret;
        }

        //office settings
        ext.point('io.ox/office/settings/detail').extend({
            index: 100,
            draw: innerDraw
        });

    };

    return Register;
});
