/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Sven Jacobi <sven.jacobi@open-xchange.com>
 */

define('io.ox/office/presentation/app/application',
    ['io.ox/office/tk/utils',
     'io.ox/office/editframework/app/editapplication',
     'io.ox/office/presentation/model/model',
     'io.ox/office/presentation/view/view',
     'io.ox/office/presentation/app/controller'
    ], function (Utils, EditApplication, PresentationModel, PresentationView, PresentationController) {

    'use strict';

    // class PresentationApplication ==========================================

    /**
     * The OX Presentation application.
     *
     * @constructor
     *
     * @extends EditApplication
     *
     * @param {Object} launchOptions
     *  All options passed to the core launcher (the ox.launch() method).
     *
     * @param {Object} [appOptions]
     *  Static application options that have been passed to the static method
     *  BaseApplication.createLauncher().
     */
    var PresentationApplication = EditApplication.extend({ constructor: function (launchOptions, appOptions) {

        // base constructor ---------------------------------------------------

        EditApplication.call(this, PresentationModel, PresentationView, PresentationController, launchOptions, appOptions);

        // initialization -----------------------------------------------------

        // destroy all class members
        this.registerDestructor(function () {
            launchOptions = appOptions = null;
        });

    }}); // class PresentationApplication

    // static methods ---------------------------------------------------------

    /**
     * Replacement for the generic method EditApplication.createLauncher()
     * without parameters, to launch presentation applications.
     */
    PresentationApplication.createLauncher = function () {
        return EditApplication.createLauncher('io.ox/office/presentation', PresentationApplication, { icon: 'fa-film' });
    };

    // exports ================================================================

    return PresentationApplication;

});
