/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/view/searchpane',
    ['io.ox/office/tk/utils',
     'io.ox/office/tk/keycodes',
     'io.ox/office/tk/forms',
     'io.ox/office/baseframework/view/toolpane',
     'gettext!io.ox/office/text'
    ], function (Utils, KeyCodes, Forms, ToolPane, gt) {

    'use strict';

    // class SearchPane =======================================================

    /**
     * Represents the search pane in OX Document edit applications.
     *
     * @constructor
     *
     * @extends ToolPane
     *
     * @param {EditApplication} app
     *  The application containing this search pane.
     */
    function SearchPane(app) {

        var // self reference
            self = this;

        // base constructor ---------------------------------------------------

        ToolPane.call(this, app, { position: 'top', classes: 'search-pane', hideOnEscape: true });

        // initialization -----------------------------------------------------

        // evil hack: move core search node into the search pane, TODO: implement own search pane
        (function () {
            var searchNode = app.getWindow().nodes.search,
                searchForm = searchNode.find('form'),
                closeButton = $(Forms.createButtonMarkup({ icon: 'fa-times', attributes: { href: '#' }, tooltip: gt('Close search') })).removeClass('button').addClass('close');

            searchNode.css({ position: 'static', display: 'block' }).find('.close').remove();
            searchForm.append(closeButton);
            self.getNode().append(searchNode);

            self.listenTo(closeButton, 'click', function () { self.hide(); });
        }());

        // when ESCAPE bubbles up to the window (not handled by application yet), hide the search pane
        this.listenTo(app.getWindowNode(), 'keydown', function (event) {
            if ((event.keyCode === KeyCodes.ESCAPE) && self.isVisible()) {
                app.getView().grabFocus();
                self.hide();
                return false;
            }
        });

        // hide search pane when application is in internal error state
        this.listenTo(app, 'docs:state:error', function () { self.hide(); });

        // fake the 'search:open' and 'search:close' events
        this.on({
            'pane:show': function () { app.getWindow().trigger('search:open'); },
            'pane:hide': function () { app.getWindow().trigger('search:close'); }
        });

        // destroy all class members on destruction
        this.registerDestructor(function () {
            app = self = null;
        });

    } // class SearchPane

    // exports ================================================================

    // derive this class from class ToolPane
    return ToolPane.extend({ constructor: SearchPane });

});
