/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/drawinglayer/view/drawingcontrols', [
    'io.ox/office/drawinglayer/view/control/charttypepicker',
    'io.ox/office/drawinglayer/view/control/chartcolorsetpicker',
    'io.ox/office/drawinglayer/view/control/chartstylesetpicker',
    'io.ox/office/drawinglayer/view/control/chartlegendpicker'
], function (ChartTypePicker, ChartColorSetPicker, ChartStyleSetPicker, ChartLegendPicker) {

    'use strict';

    // static class DrawingControls ===========================================

    /**
     * Provides different classes for GUI form controls for drawing objects in
     * a single map for convenience.
     */
    var DrawingControls = {
            ChartTypePicker: ChartTypePicker,
            ChartColorSetPicker: ChartColorSetPicker,
            ChartStyleSetPicker: ChartStyleSetPicker,
            ChartLegendPicker: ChartLegendPicker
        };

    // exports ================================================================

    return DrawingControls;

});
