/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/drawinglayer/model/shapemodel', [
    'io.ox/office/drawinglayer/model/drawingmodel'
], function (DrawingModel) {

    'use strict';

    // class ShapeModel =======================================================

    /**
     * The model of a shape object.
     *
     * @constructor
     *
     * @extends DrawingModel
     *
     * @param {EditApplication} app
     *  The application instance containing this shape object.
     *
     * @param {Object} [initAttributes]
     *  An attribute set with initial formatting attributes for the object.
     */
    function ShapeModel(app, initAttributes) {

        // base constructor ---------------------------------------------------

        DrawingModel.call(this, app, 'shape', initAttributes, { families: 'shape fill line' });

        // initialization -----------------------------------------------------

        // destroy all class members on destruction
        this.registerDestructor(function () {
            app = initAttributes = null;
        });

    } // class ShapeModel

    // exports ================================================================

    // derive this class from class DrawingModel
    return DrawingModel.extend({ constructor: ShapeModel });

});
