/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/baseframework/view/control/percentagelabel', [
    'io.ox/office/tk/utils',
    'io.ox/office/baseframework/view/control/dynamiclabel',
    'gettext!io.ox/office/main'
], function (Utils, DynamicLabel, gt) {

    'use strict';

    // class PercentageLabel ==================================================

    /**
     * A label control that shows a number as integral percentage.
     *
     * @constructor
     *
     * @extends DynamicLabel
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options supported by the base class
     *  DynamicLabel, except for the option 'captionResolver'.
     */
    function PercentageLabel(initOptions) {

        // base constructor ---------------------------------------------------

        DynamicLabel.call(this, Utils.extendOptions({
            minWidth: 90,
            style: 'text-align:right;'
        }, initOptions, {
            captionResolver: captionResolver
        }));

        // private methods ----------------------------------------------------

        /**
         * Converts the passed number to the percentage label text.
         */
        function captionResolver(value) {
            return (
                //#. a text label showing any number as integral percentage, e.g. "50%"
                //#. %1$d is the value, converted to percent
                //#. the trailing percent sign must remain in the text
                //#, c-format
                gt('%1$d%', _.noI18n(Math.round(value * 100)))
            );
        }

        // initialization -----------------------------------------------------

        // destroy all class members
        this.registerDestructor(function () {
            initOptions = null;
        });

    } // class PercentageLabel

    // exports ================================================================

    // derive this class from class DynamicLabel
    return DynamicLabel.extend({ constructor: PercentageLabel });

});
