/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/baseframework/view/control/compoundcheckbox', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/forms',
    'io.ox/office/tk/control/checkbox',
    'io.ox/office/baseframework/view/control/compoundmenumixin'
], function (Utils, Forms, CheckBox, CompoundMenuMixin) {

    'use strict';

    // class CompoundCheckBox =================================================

    /**
     * A check box control with a combined drop-down menu containing a complete
     * self-contained view component instance with completely independent
     * controls.
     *
     * @constructor
     *
     * @extends CheckBox
     * @extends CompoundMenuMixin
     *
     * @param {BaseApplication} app
     *  The application containing this control.
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options also supported by the base
     *  class CheckBox, and the mix-in class CompoundMenuMixin.
     */
    function CompoundCheckBox(app, initOptions) {

        var // the drop-down button
            menuButton = $(Forms.createButtonMarkup({ tooltip: Utils.getOption(initOptions, 'tooltip', '') }));

        // base constructors --------------------------------------------------

        CheckBox.call(this, initOptions);
        CompoundMenuMixin.call(this, app, Utils.extendOptions(initOptions, { button: menuButton }));

        // initialization -----------------------------------------------------

        // add the drop-down button to the group
        this.addChildNodes(menuButton);

        // destroy all class members
        this.registerDestructor(function () {
            app = initOptions = menuButton = null;
        });

    } // class CompoundCheckBox

    // exports ================================================================

    // derive this class from class CheckBox
    return CheckBox.extend({ constructor: CompoundCheckBox });

});
