/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/text/view/control/liststylepicker', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/control/radiolist',
    'io.ox/office/text/format/listcollection'
], function (Utils, RadioList, ListCollection) {

    'use strict';

    // class ListStylePicker ==================================================

    /**
     * Base class for a drop-down list control containing different styles for
     * bullet lists, or numbered lists.
     *
     * @constructor
     *
     * @extends RadioList
     */
    function ListStylePicker(app, predefinedListStyles, initOptions) {

        var // self reference
            self = this;

        // base constructor ---------------------------------------------------

        RadioList.call(this, Utils.extendOptions({
            highlight: function (listStyleId) { return listStyleId !== ''; },
            splitValue: ListCollection.DEFAULT_VALUE,
            updateCaptionMode: 'none',
            itemDesign: 'grid',
            sortItems: true
        }, initOptions));

        // initialization -----------------------------------------------------

        // initialize class members
        app.onInit(function () {

            var // CSS font family of the 'Cambria' font (with fall-back fonts)
                fontFamily = app.getModel().getFontCollection().getCssFontFamily('Cambria'),
                // font attributes for the drop-down list entries
                labelStyle = 'font-family:' + fontFamily + ';font-size:18px;min-width:18px;';

            // create the list entries
            self.createMenuSection('default').createMenuSection('special', { gridColumns: 1 });
            _.each(predefinedListStyles, function (listStyle, listStyleId) {
                if (Utils.trimAndCleanString(listStyle.listLabel).length > 0) {
                    self.createOptionButton(listStyleId, {
                        section: 'default',
                        label: _.noI18n(listStyle.listLabel),
                        labelStyle: labelStyle,
                        tooltip: _.noI18n(listStyle.tooltip),
                        dataValue: listStyle.listKey,
                        sortIndex: listStyleId
                    });
                } else {
                    self.createOptionButton(listStyleId, {
                        section: 'special',
                        label: _.noI18n(listStyle.tooltip),
                        dataValue: listStyle.listKey
                    });
                }
            });
        });

        this.getMenuNode().addClass('list-style-picker');

    } // class ListStylePicker

    // exports ================================================================

    // derive this class from class RadioList
    return RadioList.extend({ constructor: ListStylePicker });

});
