/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/view/control/cellbordercolorpicker', [
    'io.ox/office/tk/utils',
    'io.ox/office/editframework/utils/color',
    'io.ox/office/editframework/view/control/colorpicker',
    'io.ox/office/spreadsheet/view/labels'
], function (Utils, Color, ColorPicker, Labels) {

    'use strict';

    // class CellBorderColorPicker ============================================

    /**
     * The selector for the cell border color.
     *
     * @constructor
     *
     * @extends ColorPicker
     */
    function CellBorderColorPicker(app, initOptions) {

        var // self reference
            self = this;

        // base constructor ---------------------------------------------------

        ColorPicker.call(this, app, getGridColor(), Utils.extendOptions({
            icon: 'docs-cell-fill-color',
            tooltip: Labels.BORDER_COLOR_LABEL
        }, initOptions));

        // private methods ----------------------------------------------------

        /**
         * Returns the effective color used for the 'automatic color' list
         * entry of this color picker control (which is the grid color of the
         * active sheet).
         *
         * @returns {Object}
         *  The color used for the 'automatic color' list entry.
         */
        function getGridColor() {
            return app.getView().getEffectiveGridColor(Color.BLACK);
        }

        // initialization -----------------------------------------------------

        // refresh the 'automatic' border color (depends on sheet grid color)
        app.onInit(function () {
            self.listenTo(app.getView(), 'change:sheet:viewattributes', function () {
                self.setAutoColor(getGridColor());
            });
        });

        // destroy all class members on destruction
        this.registerDestructor(function () {
            app = initOptions = self = null;
        });

    } // class CellBorderColorPicker

    // exports ================================================================

    // derive this class from class ColorPicker
    return ColorPicker.extend({ constructor: CellBorderColorPicker });

});
