/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/preview/view/controls',
    ['io.ox/office/tk/utils',
     'io.ox/office/baseframework/view/basecontrols',
     'gettext!io.ox/office/preview'
    ], function (Utils, BaseControls, gt) {

    'use strict';

    var // class name shortcuts
        Button = BaseControls.Button;

    // static class PreviewControls ===========================================

    /**
     * Additional classes defining specialized GUI controls for the OX Viewer
     * application.
     *
     * @extends BaseControls
     */
    var PreviewControls = _.clone(BaseControls);

    // constants --------------------------------------------------------------

    /**
     * Standard options for the 'Previous page' button.
     *
     * @constant
     */
    PreviewControls.PREV_BUTTON_OPTIONS = { icon: 'fa-arrow-up', tooltip: gt('Show previous page') };

    /**
     * Standard options for the 'Next page' button.
     *
     * @constant
     */
    PreviewControls.NEXT_BUTTON_OPTIONS = { icon: 'fa-arrow-down', tooltip: gt('Show next page') };


    /**
     * Standard options for the 'Previous page' button.
     *
     * @constant
     */
    PreviewControls.TOUCH_PREV_BUTTON_OPTIONS = { icon: 'fa-arrow-left', tooltip: gt('Show previous page')};

    /**
     * Standard options for the 'Next page' button.
     *
     * @constant
     */
    PreviewControls.TOUCH_NEXT_BUTTON_OPTIONS = { icon: 'fa-arrow-right', tooltip: gt('Show next page')};

    // class EditDocumentButton ===============================================

    /**
     * The button to start editing the current document.
     *
     * @constructor
     *
     * @extends Button
     */
    PreviewControls.EditDocumentButton = Button.extend({ constructor: function (initOptions) {

        var // self reference
            self = this;

        // base constructor ---------------------------------------------------

        Button.call(this, Utils.extendOptions({
            icon: 'fa-pencil',
            tooltip: gt('Edit document')
        }, initOptions));

        // initialization -----------------------------------------------------

        // hide the button completely, if it is disabled
        this.on('group:enable', function (event, state) { self.toggle(state); });

    }}); // class EditDocumentButton

    // exports ================================================================

    return PreviewControls;

});
