/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Edy Haryono <edy.haryono@open-xchange.com>
 */

define('io.ox/office/portal/view/toolbarview',
    ['gettext!io.ox/office/portal',
        'io.ox/office/portal/portalutils',
        'io.ox/office/portal/action/toolbaractionstext',
        'io.ox/office/portal/action/toolbaractionsspreadsheet',
        'io.ox/core/extensions'
    ], function (gt, PortalUtils, ToolbarActionsText, ToolbarActionsSpreadsheet, Ext) {

        'use strict';

        var toolbarView = Backbone.View.extend({

            tagName: 'div',

            className: 'office-portal-toolbar',

            events: {

            },

            initialize: function () {

                this.render(PortalUtils.getActiveApp(this.model));

            },

            render: function (appBaseName) {

                this.$el.find('.office-portal-toolbar').remove();

                // create portal toolbar markup
                var toolbar = $('<div>').addClass('office-portal-toolbar f6-target');

                if ((_.browser.Android) && (appBaseName === 'text') && !PortalUtils.supportedChromeVersionOnAndroidForText()) { toolbar.addClass('reduced-toolbar-functionality'); }

                // append to root element of this view
                this.$el.prepend(toolbar);

                // create all toolbar extension points, actions, and draw them.
                if (appBaseName === 'spreadsheet') {
                    ToolbarActionsSpreadsheet.toolbarPoint.invoke('draw', toolbar, Ext.Baton({ app : this.model }));
                } else {
                    ToolbarActionsText.toolbarPoint.invoke('draw', toolbar, Ext.Baton({ app : this.model }));
                }

                // adding tooltips to all links in the tool bar
                _.each(toolbar.children('a'), function (oneLink) {
                    var oneLink$ = $(oneLink);

                    if (oneLink$.attr('title')) {
                        oneLink$
                        .attr({
                            'data-toggle': 'tooltip',
                            'data-placement': 'bottom',
                            'title': oneLink$.attr('title')
                        })
                        .tooltip();
                    }
                });

                return this;
            }
        });

        return toolbarView;

    });