/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2014 Open-Xchange Inc., Tarrytown, NY, USA. info@open-xchange.com
 *
 * @author Edy Haryono <edy.haryono@open-xchange.com>
 */

define('io.ox/office/portal/collection/templatecollection',
    ['io.ox/office/portal/model/templatemodel'],
    function (TemplateModel) {

        'use strict';

        var templateCollection = Backbone.Collection.extend({

            model : TemplateModel,

            /**
             * Fills this collection with passed array of template objects.
             *
             * @param {Array} templateList
             *  An array of template objects (infostore file descriptors)
             */
            setData: function (templateList) {

                var self = this;

                _.each(templateList, function (template) {
                    self.add(new TemplateModel(template), {merge: true});
                });

            },

            /**
             * Get templates according to passed template type.
             *
             * @param {String} appBaseName
             *  The base name of the current application.
             *
             * @param {String = 'all'} source
             *  valid types: 'all', 'user' or 'global'. Defaults to 'all' if omitted.
             *
             * @return {Array}
             *  An array of template models.
             *
             */
            getTemplates: function (appBaseName, source) {

                var models = this.models;

                source = source || 'all';

                function templateFilter(templateModel) {
                    if (source === 'all') { return templateModel.get('type') === appBaseName; }
                    return templateModel.get('source') === source && templateModel.get('type') === appBaseName;
                }

                return _.filter(models, templateFilter);

            },

            /**
             * Comparator function for sorting templates according to their filenames alphabetically.
             *
             * @param {Backbone.Model} model
             *  a template model.
             *
             * @returns {String}
             *  returns the values to be sorted.
             */
            comparator: function (model) {
                return model.get('filename').toLowerCase();
            }

        });

        return templateCollection;

    });
