/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/utils/lineheight', function () {

    'use strict';

    // static class LineHeight ================================================

    /**
     * Predefined values for the 'lineHeight' attribute for paragraphs.
     */
    var LineHeight = {
            NORMAL:   { type: 'normal' },
            SINGLE:   { type: 'percent', value: 100 },
            _115:     { type: 'percent', value: 115 },
            ONE_HALF: { type: 'percent', value: 150 },
            DOUBLE:   { type: 'percent', value: 200 }
        };

    // exports ================================================================

    return LineHeight;

});
