/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define('io.ox/office/drawinglayer/model/drawingstylecollection',
    ['io.ox/office/tk/utils',
     'io.ox/office/editframework/utils/color',
     'io.ox/office/editframework/model/stylecollection'
    ], function (Utils, Color, StyleCollection) {

    'use strict';

    var // definitions for common drawing attributes
        DRAWING_ATTRIBUTE_DEFINITIONS = {

            // generic attributes ---------------------------------------------

            /**
             * Absolute horizontal position of the drawing, as number in 1/100
             * of millimeters. May be overridden by other specialized anchor
             * attributes in some applications.
             */
            left: { def: 0 },

            /**
             * Absolute vertical position of the drawing, as number in 1/100 of
             * millimeters. May be overridden by other specialized anchor
             * attributes in some applications.
             */
            top: { def: 0 },

            /**
             * Width of the drawing, as number in 1/100 of millimeters. May be
             * overridden by other specialized anchor attributes in some
             * applications.
             */
            width: { def: 0 },

            /**
             * Height of the drawing, as number in 1/100 of millimeters. May be
             * overridden by other specialized anchor attributes in some
             * applications.
             */
            height: { def: 0 },

            /**
             * The name of the drawing object.
             */
            name: { def: '' },

            /**
             * A detailed description for the drawing object.
             */
            description: { def: '' },

            /**
             * Flip the drawing horizontally (swap left and right side).
             */
            flipH: { def: false },

            /**
             * Flip the drawing vertically (swap top and bottom side).
             */
            flipV: { def: false },

            /**
             * Replacement image for unsupported drawing objects. The string
             * contains either Base64 encoded bitmap data, or SVG mark-up.
             */
            replacementData: { def: '', scope: 'element' },

            // image specific attributes --------------------------------------

            /**
             * URL pointing to the image data. If the image is embedded in the
             * document file, the URL will be relative to the document.
             */
            imageUrl: { def: '', scope: 'element' },

            /**
             * Image data.
             */
            imageData: { def: '', scope: 'element' },

            /**
             * Amount of left part of the image cropped outside the object
             * border, in percent.
             */
            cropLeft: { def: 0 },

            /**
             * Amount of right part of the image cropped outside the object
             * border, in percent.
             */
            cropRight: { def: 0 },

            /**
             * Amount of top part of the image cropped outside the object
             * border, in percent.
             */
            cropTop: { def: 0 },

            /**
             * Amount of bottom part of the image cropped outside the object
             * border, in percent.
             */
            cropBottom: { def: 0 }
        },

        // definitions for drawing fill attributes
        FILL_ATTRIBUTE_DEFINITIONS = {

            /**
             *  Type of the fill. Supported values are:
             *  - 'none': Not filled (transparent).
             *  - 'auto': specific default fill, dependent on context.
             *  - 'solid': single fill color ('color' attribute).
             */
            type: { def: 'none' },

            /**
             * Fill color (used for fill type 'solid').
             */
            color: { def: Color.AUTO }
        },

        // definitions for drawing outline attributes (supports ALL fill attributes)
        LINE_ATTRIBUTE_DEFINITIONS = _.extend(_.clone(FILL_ATTRIBUTE_DEFINITIONS), {

            /**
             * Width of the outline, in 1/100 of millimeters.
             */
            width: { def: 0 }
        }),

        // definitions for linked text attributes
        TEXT_ATTRIBUTE_DEFINITIONS = {

            /**
             * A specification for the source of the text contents of a drawing
             * object, or of a sub object in a complex drawing (e.g. a chart
             * title). Can be a plain array with literal strings, or a string
             * with an application-dependent descriptor of the text source
             * (e.g. a spreadsheet formula with cell addresses).
             */
            link: { def: [] }
        },

        // definitions for generic chart attributes
        CHART_ATTRIBUTE_DEFINITIONS = {

            /**
             * The type of the chart. Specifies how the data series will be
             * rendered.
             */
            type: { def: 'column2d', scope: 'element' },

            /**
             * clustered, stacked, percent, the way how multi series lay to each other (bar, column and area)
             */
            stacking: { def : 'clustered', scope: 'element' },

            /**
             * if true line charts are smooth spline charts
             */
            curved: { def : false, scope: 'element' },

            /**
             * color patterns, background and highlights
             */
            chartStyleId: { def: 0, scope: 'element' },

            rotation: { def: 0, scope: 'element' }, //TODO: only for pie & donut, should be moved

            /**
             * defines if the points of the first series are same color or not
             */
            varyColors: { def: false, scope: 'element' },

            dataLabel: { def: false, scope: 'element' }
        },

        // definitions for chart data series attributes
        CHART_SERIES_ATTRIBUTE_DEFINITIONS = {

            /**
             * Data source for the series title. May be an array of constant
             * strings, or a string with an application-dependent dynamic data
             * source definition.
             */
            title: { def: [] },

            /**
             * Data source for the values of all data points. May be an array
             * of constant values, or a string with an application-dependent
             * dynamic data source definition.
             */
            values: { def: [] },

            /**
             * Data source for the categories of all data points, or the X
             * values in scatter and bubble charts. May be an array of constant
             * values, or a string with an application-dependent dynamic data
             * source definition.
             */
            names: { def: [] },

            /**
             * Data source for the bubble sizes of all data points in bubble
             * charts. May be an array of constant values, or a string with an
             * application-dependent dynamic data source definition.
             */
            bubbles: { def: [] }
        },

        // definitions for chart axis attributes
        CHART_AXIS_ATTRIBUTE_DEFINITIONS = {
            type: { def: 'value' },
            min: { def: 'auto' },
            max: { def: 'auto' },
            label: { def: false }
        },

        // definitions for chart legend attributes
        CHART_LEGEND_ATTRIBUTE_DEFINITIONS = {

            /**
             * Position of the legend object. The value 'off' hides the legend,
             * otherwise, the values 'bottom', 'top', 'left', 'right', or
             * 'topRight' show the legend at the respective border in the chart
             * area.
             */
            pos: { def: 'off' }
        };

    // class DrawingStyleCollection ===========================================

    /**
     * Contains the style sheets for drawing formatting attributes.
     *
     * @constructor
     *
     * @extends StyleCollection
     *
     * @param {TextApplication} app
     *  The root application instance.
     *
     * @param {DocumentStyles} documentStyles
     *  Collection with the style containers of all style families.
     */
    function DrawingStyleCollection(app, documentStyles, initOptions) {

        // base constructor ---------------------------------------------------

        StyleCollection.call(this, app, documentStyles, 'drawing', initOptions);

        // initialization -----------------------------------------------------

        documentStyles
            .registerAttributeDefinitions('drawing', DRAWING_ATTRIBUTE_DEFINITIONS)
            .registerAttributeDefinitions('fill', FILL_ATTRIBUTE_DEFINITIONS)
            .registerAttributeDefinitions('line', LINE_ATTRIBUTE_DEFINITIONS)
            .registerAttributeDefinitions('text', TEXT_ATTRIBUTE_DEFINITIONS)
            .registerAttributeDefinitions('chart', CHART_ATTRIBUTE_DEFINITIONS)
            .registerAttributeDefinitions('series', CHART_SERIES_ATTRIBUTE_DEFINITIONS)
            .registerAttributeDefinitions('axis', CHART_AXIS_ATTRIBUTE_DEFINITIONS)
            .registerAttributeDefinitions('legend', CHART_LEGEND_ATTRIBUTE_DEFINITIONS);

    } // class DrawingStyleCollection

    // exports ================================================================

    // derive this class from class StyleCollection
    return StyleCollection.extend({ constructor: DrawingStyleCollection });

});
