'use strict';

module.exports = function (grunt) {

    grunt.config.extend('copy', {
        static: {
            files: [
                {
                    src: ['apps/**/*.json', '!apps/**/manifest.json'],
                    dest: 'build/'
                }
            ]
        },
        third_party: {
            files: [
                {
                    expand: true,
                    src: ['lib/canvasjs.min.js'],
                    cwd: 'lib/canvasjs/',
                    dest: 'build/apps/io.ox/office/drawinglayer/',
                    filter: 'isFile'
                }
            ]
        },
        specs: {
            files: [
                {
                    src: ['spec/**/*.js'],
                    expand: true,
                    filter: 'isFile',
                    dest: 'build/'
                },
                {
                    src: ['spec/fixtures/**/*'],
                    expand: true,
                    filter: 'isFile',
                    dest: 'build/'
                }
            ]
        }
    });

    grunt.registerTask('copy_build', [
        'newer:copy:static',
        'newer:copy:apps',
        'newer:copy:themes',
        'newer:copy:specs',
        'newer:copy:third_party'
    ]);
};
