/**
 * All content on this website (including text, images, source code and any
 * other original works), unless otherwise noted, is licensed under a Creative
 * Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2013 Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/spreadsheet/view/cellstylepicker',
    ['io.ox/office/tk/utils',
     'io.ox/office/editframework/view/editcontrols',
     'io.ox/office/editframework/model/format/color',
     'io.ox/office/spreadsheet/utils/clipboard',
     'gettext!io.ox/office/spreadsheet'
    ], function (Utils, EditControls, Color, Clipboard, gt) {

    'use strict';

    // class CellStylePicker ==================================================

    function CellStylePicker(app, initOptions) {

        var self = this;

        var styles = app.getModel().getStyleSheets('cell');

        var captionParagraph = $('<span>');
        captionParagraph.append($('<span>').text(gt('Cell Template')));

        // base constructor ---------------------------------------------------

        EditControls.StyleSheetPicker.call(self, app, 'cell', Utils.extendOptions({
            icon: 'docs-table-style',
            tooltip: gt('Cell style'),
            gridColumns: 6,
            updateCaptionMode: 'none',
            i18nModulePath: 'io.ox/office/spreadsheet/resource/cellstylenames',
            sections: ['markup', 'headings', 'themes', 'hidden']
        }, initOptions));

        // private methods ----------------------------------------------------

        function createItemHandler(event, buttonNode, sectionId, styleId) {
            var paragraph = createNode(Utils.getControlLabel(buttonNode), styleId, buttonNode);

            setFormatting(paragraph, styleId);
        }

        function createNode(label, styleId, parent) {

            var span = parent.children(0);
            if (styleId) {

                var att = styles.getStyleSheetAttributes(styleId);

                var cell = {
                        attributes: att
                    };

                var charStyles = Clipboard.getCssCharacterStyles(cell, styles);
                var cellStyles = Clipboard.getCssCellStyles(cell, styles);

                span.attr('style', charStyles + cellStyles + ' width: 100%; height: 100%; box-sizing: border-box; display: block;');
            }

            var translate = _.noI18n(label);

            span.children(0).text(translate);

            parent.attr('title', translate);
//            parent.attr('aria-label', translate);
//            parent.attr('data-value', translate);

            return span;
        }

        function setFormatting(paragraph, styleId) {
            styles.setElementAttributes(paragraph, { styleId: styleId }, { preview: true });

        }

        function updateHandler(styleId) {
            var // the span element taking the style sheet name
            span = captionParagraph.children('span').first(),
            // the name of the style sheet
            styleName = styles.getName(styleId);

            if (_.isString(styleId) && _.isString(styleName)) {
                var translate = self.translateStyleName(styleName);
                setFormatting(captionParagraph, styleId);

                Utils.setControlCaption(self.getMenuButton(), { icon: 'docs-table-style', label: translate });

            } else {
                span.text('');
            }
        }

        // initialization -----------------------------------------------------

        this.getMenuButton().children('div.caption').append(captionParagraph);
        this.registerUpdateHandler(updateHandler);

        // register a handler that inserts a cell style node into each list item
        this.getMenu().on('create:item', createItemHandler);

    } // class CellStylePicker

    // exports ================================================================

    return EditControls.StyleSheetPicker.extend({ constructor: CellStylePicker });

});
