/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Sven Jacobi <sven.jacobi@open-xchange.com>
 */

define('io.ox/office/presentation/app/application',
    ['io.ox/office/tk/utils',
     'io.ox/office/editframework/app/editapplication',
     'io.ox/office/presentation/model/model',
     'io.ox/office/presentation/view/view',
     'io.ox/office/presentation/app/controller'
    ], function (Utils, EditApplication, PresentationModel, PresentationView, PresentationController) {

    'use strict';

    // class PresentationApplication ==========================================

    /**
     * The OX Presentation application.
     *
     * @constructor
     *
     * @extends EditApplication
     *
     * @param {Object} [appOptions]
     *  A map of static application options, that have been passed to the
     *  static method BaseApplication.createLauncher().
     *
     * @param {Object} [launchOptions]
     *  A map of options to control the properties of the application. Supports
     *  all options supported by the base class EditApplication.
     */
    var PresentationApplication = EditApplication.extend({ constructor: function (appOptions, launchOptions) {

        // base constructor ---------------------------------------------------

        EditApplication.call(this, PresentationModel, PresentationView, PresentationController, appOptions, launchOptions);

    }}); // class PresentationApplication

    // static methods ---------------------------------------------------------

    /**
     * Replacement for the generic method EditApplication.createLauncher()
     * without parameters, to launch presentation applications.
     */
    PresentationApplication.createLauncher = function () {
        return EditApplication.createLauncher('io.ox/office/presentation', PresentationApplication, { icon: 'fa-film' });
    };

    // exports ================================================================

    return PresentationApplication;

});
