/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Edy Haryono <edy.haryono@open-xchange.com>
 */

define('io.ox/office/portal/collection/documentcollection',
    ['io.ox/office/portal/model/documentmodel',
        'io.ox/office/portal/utils',
        'settings!io.ox/office'
    ], function (DocumentModel, Utils, Settings) {

    'use strict';

    var documentCollection = Backbone.Collection.extend({

        model : DocumentModel,

        initialize: function () {

            var self = this;

            // get recent documents from user settings
            var recents = Settings.get('portal/recents'),
                recentsArray;

            // Set empty array if user doesnt have recents list yet.
            // If settings is already an array (old version), clear it.
            if (_.isUndefined(recents) || _.isArray(recents)) {
                recentsArray = [];
            } else { // try to parse recent file list
                try {
                    recentsArray = JSON.parse(recents); // parse existing JSON List
                } catch (ex) {
                    Utils.exception(ex);
                    recentsArray = [];
                }
            }

            // populate the collection with recent documents
            _.each(recentsArray, function (recentDocument) {
                self.add(new DocumentModel(recentDocument), {merge: true});
            });

        },

        // sort documents automatically by their last opened timestamp, descending.
        comparator: function (model) {
            return -model.get('last_opened');
        }

    });

    return documentCollection;

});