/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/view/editdialogmixin', function () {

    'use strict';

    // mix-in class EditDialogMixin ===========================================

    /**
     * A mix-in class that extends a dialog instance (instances of the toolkit
     * class Dialogs.ModalDialog or any of its subclasses) with a listener for
     * the document edit mode. If the document loses edit rights, the dialog
     * instance will be closed automatically.
     *
     * @constructor
     *
     * @param {EditApplication} app
     *  The application instance the dialog instance has been created for.
     */
    function EditDialogMixin(app) {

        var // self reference
            self = this,

            // the document model
            model = app.getModel();

        // private methods ----------------------------------------------------

        // close the dialog if document switches to read-only mode
        function changeEditModeHandler(event, editMode) {
            if (!editMode) { self.close(); }
        }

        // initialization -----------------------------------------------------

        // listen to read-only mode, close dialog automatically
        model.on('change:editmode', changeEditModeHandler);

        // unregister listener after closing the dialog
        this.on('close', function () {
            model.off('change:editmode', changeEditModeHandler);
            self = app = model = null;
        });

    } // class EditDialogMixin

    // exports ================================================================

    return EditDialogMixin;

});
