define('io.ox/core/gettext', function () {

    'use strict';

    function gt() {
        return function (text) {
            var args = arguments;
            return text.replace(/%(\d+)\$[ds]/g, function (match, index) {
                return args[index];
            });
        };
    }

    gt.language = $.Deferred().resolve('en_US');

    return gt;
});

define('gettext', {
    load: function (name, parentRequire, load) {
        parentRequire([name + '.en_US'], load);
    }
});
