/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/tk/control/checkbox',
    ['io.ox/office/tk/utils',
     'io.ox/office/tk/control/button'
    ], function (Utils, Button) {

    'use strict';

    // class CheckBox =========================================================

    /**
     * Creates a container element used to hold a toggle button, styled like a
     * regular check box.
     *
     * @constructor
     *
     * @extends Button
     *
     * @param {Object} [initOptions]
     *  A map of options to control the properties of the check box. Supports
     *  all options of the Button base class, except for the 'toggle' option
     *  which will always be set to true, the 'icon' option which will be used
     *  to draw the checked/unchecked square, and 'highlight' (check boxes will
     *  never be highlighted).
     */
    function CheckBox(initOptions) {

        var // self reference
            self = this;

        // base constructor ---------------------------------------------------

        Button.call(this, Utils.extendOptions(initOptions, {
            toggle: true,
            highlight: function () { return false; } // never highlight the check box
        }));

        // private methods ----------------------------------------------------

        /**
         * The update handler for this button.
         */
        function updateHandler(state) {
            self.setIcon(state ? 'fa-check-square-o' : 'fa-square-o');
        }

        // initialization -----------------------------------------------------

        // add special marker classes used to adjust formatting
        this.getNode().addClass('no-borders check-box');

        // register an update handler that updates the check icon
        this.registerUpdateHandler(updateHandler);

    } // class CheckBox

    // exports ================================================================

    // derive this class from class Button
    return Button.extend({ constructor: CheckBox });

});
