/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/drawing/axismodel',
    ['io.ox/office/drawinglayer/view/chartstyleutil',
     'io.ox/office/editframework/model/format/attributedmodel',
     'io.ox/office/spreadsheet/model/drawing/gridlinemodel'
    ], function (ChartStyleUtil, AttributedModel, GridlineModel) {

    'use strict';

    // class AxisModel =====================================================

    /**
     * visualisation model for chart axes,
     * it defines colors and textual colors
     */
    function AxisModel(chart, attrs, dataAxis, title, stripLines) {
        var grid = new GridlineModel(chart, {}, dataAxis);


        // base constructor ---------------------------------------------------

        AttributedModel.call(this, chart.getApp(), attrs, { additionalFamilies: ['axis', 'line', 'character'] });

        // methods ------------------------------------------------------------

        this.refreshInfo = function () {
            var app = chart.getApp();
            if (!dataAxis) {
                return;
            }
            var view = app.getView();
            if (!view) {
                return;
            }
            var attrs = this.getMergedAttributes();

            ChartStyleUtil.handleLineProps(chart, attrs.line, dataAxis, 'line');
            ChartStyleUtil.handleLineProps(chart, attrs.line, dataAxis, 'tick');

            if (attrs.axis.label) {
                ChartStyleUtil.handleCharacterProps(chart, attrs.character, dataAxis, 'label');
            } else {
                dataAxis.labelFontColor = 'transparent';
                dataAxis.labelFontSize = 1;
            }

            if (stripLines && stripLines.length) {
                //TODO: stripline is used for a X-axis one the zero point
                stripLines[0].color = dataAxis.lineColor;
                stripLines[0].thickness = dataAxis.lineThickness;
            }

            grid.refreshInfo();

            var titleAtt = title.getMergedAttributes();
            dataAxis.title = titleAtt.text.link[0];
            if (dataAxis.title) {
                ChartStyleUtil.handleCharacterProps(chart, titleAtt.character, dataAxis, 'title');
            }

        };

        this.getGrid = function () {
            return grid;
        };

        this.getTitle = function () {
            return title;
        };

        this.registerDestructor(function () {
            grid.destroy();
            if (title) {
                title.destroy();
            }
            grid = title = null;
        });

    } // class AxisModel

    // exports ================================================================
    return AttributedModel.extend({ constructor: AxisModel });

});
