/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/presentation/view/view',
    ['io.ox/office/tk/utils',
     'io.ox/office/editframework/view/editview',
     'less!io.ox/office/presentation/view/style'
    ], function (Utils, EditView) {

    'use strict';

    // class PresentationView =================================================

    /**
     * @constructor
     *
     * @extends EditView
     */
    function PresentationView(app) {

        var // self reference
            self = this;

        // base constructor ---------------------------------------------------

        EditView.call(this, app, {
            initHandler: initHandler,
            deferredInitHandler: deferredInitHandler,
            overlayMargin: { right: Utils.SCROLLBAR_WIDTH, bottom: Utils.SCROLLBAR_HEIGHT }
        });

        // private methods ----------------------------------------------------

        /**
         * Initialization after construction.
         */
        function initHandler() {
        }

        /**
         * Initialization after importing the document. Creates all tool boxes
         * in the side pane and overlay pane. Needed to be executed after
         * import, to be able to hide specific GUI elements depending on the
         * file type.
         */
        function deferredInitHandler() {
            if (Utils.DEBUG) {
                self.createDebugToolBox();
            }
        }

        // methods ------------------------------------------------------------

    } // class PresentationView

    // exports ================================================================

    // derive this class from class EditView
    return EditView.extend({ constructor: PresentationView });

});
