/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2014 Open-Xchange Inc., Tarrytown, NY, USA. info@open-xchange.com
 *
 * @author Edy Haryono <edy.haryono@open-xchange.com>
 */

define('io.ox/office/portal/view/templateview',
    ['gettext!io.ox/office/portal',
        'io.ox/office/portal/utils',
        'io.ox/core/extensions',
        'io.ox/office/portal/action/templateactions'
    ], function (gt, Utils, Ext, TemplateActions) {

        'use strict';

        var templateView = Backbone.View.extend({

            tagName: 'div',

            className: 'office-portal-template',

            events: {

            },

            initialize: function () {

                this.listenTo(this.collection, 'change', this.render);
                this.listenTo(this.collection, 'destroy', this.remove);

                // draw templates for enabled apps
                this.render(Utils.getActiveApp(this.model));

            },

            /**
             * Renders templates section of supported applications and 'My Templates' section
             *
             * @param {String} appBaseName
             *  The base name of the current application.
             *
             * @returns {templateView}
             */
            render: function (appBaseName) {

                var self = this;

                var templateTypeWrapper = $('<div>').addClass('template-type-wrapper col-xs-12'),
                    templateWrapper = $('<div>').addClass('template-list f6-target');

                templateTypeWrapper.append(templateWrapper);

                self.$el.append(templateTypeWrapper);

                // draw create with blank template
                TemplateActions[appBaseName].invoke('draw', templateWrapper, Ext.Baton({ app : self.model }));

                // receiving template files from template manager
                self.collection.templatesDef.done(function (data) {

                    var // list of all templates
                        templates = data.templates || [],
                        // list of user templates
                        myTemplates = null,
                        // list of global templates
                        appTemplates = null;

                    // get application specific user templates e. g. text, spreadsheet
                    myTemplates = _.filter(templates, function (template) {
                        return appBaseName === template.type && template.source === 'user';
                    });

                    // render text and spreadsheet local default templates
                    _.each(_.sortBy(myTemplates, function (template) { return template.filename.toLowerCase(); }), function (template) {
                        TemplateActions[appBaseName + 'user'].invoke('draw', templateWrapper, Ext.Baton({ data : template }));
                    });

                    // get application specific global templates e. g. text, spreadsheet
                    appTemplates = _.filter(templates, function (template) {
                        return template.type === appBaseName && template.source === 'global';
                    });

                    // render text and spreadsheet local default templates
                    _.each(_.sortBy(appTemplates, function (template) { return template.filename.toLowerCase(); }), function (template) {
                        TemplateActions[appBaseName + 'global'].invoke('draw', templateWrapper, Ext.Baton({ data : template }));
                    });

                });

                return this;
            }

        });

        return templateView;

    });
