/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define('io.ox/office/portal/spreadsheet/main',
    ['settings!io.ox/office',
     'gettext!io.ox/office/portal',
     'io.ox/core/extensions',
     'io.ox/core/extPatterns/links',
     'io.ox/office/baseframework/app/extensionregistry',
     'io.ox/files/api',
     'io.ox/office/portal/mainhelper',
     'less!io.ox/office/portal/style'
    ], function (Settings, gt, Ext, Links, ExtensionRegistry, FilesAPI, MainHelper) {

        'use strict';

        var // the application name
            appName = 'io.ox/office/portal/spreadsheet',
            // the application title
            appTitle = 'Spreadsheet',
            // the OX Appsuite application object
            app = ox.ui.createApp({ name: appName, title: appTitle });

        app.setLauncher(MainHelper.getAppLauncher(app, appName, appTitle));

        return {
            getApp: app.getInstance
        };

    });
