/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2014 Open-Xchange Inc., Tarrytown, NY, USA. info@open-xchange.com
 *
 * @author Edy Haryono <edy.haryono@open-xchange.com>
 */

/**
 *  Defines extensions and actions of the recent documents pane
 */
define('io.ox/office/portal/action/recentsactions',
    ['io.ox/core/extensions',
     'io.ox/core/extPatterns/links',
     'io.ox/core/extPatterns/actions',
     'io.ox/office/portal/utils',
     'io.ox/office/tk/keycodes'],
function (Ext, Links, CoreActions, Utils, KeyCodes) {

    'use strict';


    var RecentsExtensions = function () {

        var recentDocumentExtension = 'io.ox/portal/office/recents/document';

        this.documentPoint = Ext.point(recentDocumentExtension);

        new Links.Action(recentDocumentExtension + '/open', {

            action: function (baton) {
                var appModuleName = Utils.getModuleName(baton.data.filename);
                ox.launch(appModuleName + '/main', { action: 'load', file: baton.data });
            }

        });

        this.documentPoint.extend({

            id: 'recent_document',

            draw: function (baton) {

                var link = $('<a>').addClass('document-link row')
                    .attr({
                        'data-toggle': 'tooltip',
                        'data-placement': 'top',
                        'title': baton.data.filename,
                        'tabindex': 0
                    })
                    .tooltip(),
                    metadata = $('<div>').addClass('document-metadata'),
                    name = $('<div>').addClass('document-name col-xs-8').html(baton.data.filename),
                    date = $('<div>').addClass('document-date col-xs-4').html(Utils.formatDate(baton.data.last_modified ? baton.data.last_modified : baton.data.last_opened));

                link.append(
                    metadata.append(
                        name.prepend(Utils.createDocumentIcon(baton.data.filename)), date
                    )
                );

                link.click(function () {
                    CoreActions.invoke(recentDocumentExtension + '/open', this, baton);
                });

                link.on('keydown', function (event) {
                    if (KeyCodes.matchKeyCode(event, 'ENTER') || KeyCodes.matchKeyCode(event, 'SPACE')) { $(this).trigger('click'); }
                    if (KeyCodes.matchKeyCode(event, 'LEFT_ARROW') || KeyCodes.matchKeyCode(event, 'UP_ARROW')) { Utils.moveFocus($(this), 'prev'); }
                    if (KeyCodes.matchKeyCode(event, 'RIGHT_ARROW') || KeyCodes.matchKeyCode(event, 'DOWN_ARROW')) { Utils.moveFocus($(this), 'next'); }
                });

                this.append(link);
            }

        });

    };

    return new RecentsExtensions();

});