/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Kristof Kamin <kristof.kamin@open-xchange.com>
 */

define([
    'globals/apphelper',
    'io.ox/office/text/format/tablecellstyles',
    'io.ox/office/editframework/utils/attributeutils',
    'io.ox/office/textframework/utils/position'
], function (AppHelper, TableCellStyles, AttributeUtils, Position) {

    'use strict';

    // class TableCellStyles ==============================================

    describe('Text format class TableCellStyles', function () {

        // private helpers ----------------------------------------------------
        var positions    = ['top', 'center', 'bottom'],
            domAttr      = 'verticalalign',
            domClass     = '.cell',
            cellAttr     = 'alignVert',
            attributes   = null,
            selection    = null,
            rootNode     = null,
            domPos       = null,

            // the operations to be applied by the document model
            OPERATIONS  = [
                { name: 'setDocumentAttributes', attrs: { document: { defaultTabStop: 1270, zoom: { value: 100 } }, page: { width: 21000, height: 29700, marginLeft: 2540, marginTop: 2540, marginRight: 2540, marginBottom: 2540, marginHeader: 1248, marginFooter: 1248 }, character: { fontName: 'Calibri', fontSize: 11, language: 'x-none', languageEa: 'en-US', languageBidi: 'ar-SA' }, paragraph: { lineHeight: { value: 107, type: 'percent' }, marginBottom: 282 } } },
                { name: 'insertTable', start: [0], type: 'table', attrs: { table: { tableGrid: [5300, 5300, 5302], width: 15902, exclude: ['lastRow', 'lastCol', 'bandsVert'] } } },
                { name: 'insertRows', start: [0, 0], attrs: { row: { height: 1500 } } },
                { name: 'insertCells', start: [0, 0, 0], attrs: { cell: { alignVert: positions[0] } } },
                { name: 'insertCells', start: [0, 0, 1], attrs: { cell: { alignVert: positions[1] } } },
                { name: 'insertCells', start: [0, 0, 2], attrs: { cell: { alignVert: positions[2] } } },
                { name: 'insertParagraph', start: [0, 0, 0, 0] },
                { name: 'insertParagraph', start: [0, 0, 1, 0] },
                { name: 'insertParagraph', start: [0, 0, 2, 0] },
                { name: 'insertText', start: [0, 0, 0, 0, 0], text: 'Hello World' },
                { name: 'insertText', start: [0, 0, 1, 0, 0], text: 'Hello World' },
                { name: 'insertText', start: [0, 0, 2, 0, 0], text: 'Hello World' }
            ];

        AppHelper.createTextApp('ooxml', OPERATIONS).done(function (app) {
            var model = app.getModel();
            selection = model.getSelection();
            rootNode = selection.getRootNode();
        });

        // existence check ----------------------------------------------------
        it('should exist', function () {
            expect(TableCellStyles).to.be.a('function');
        });

        // DOC-588 User sees text vertically aligned in table cells
        describe('check if attribute exists', function () {

            it('should have vertical alignment attribute', function () {
                domPos = Position.getDOMPosition(rootNode, [0, 0, 0]);
                attributes = AttributeUtils.getExplicitAttributes(domPos.node);
                expect(attributes.cell[cellAttr]).to.equal(positions[0]);
                expect(attributes.cell[cellAttr]).to.not.equal(positions[1]);
                expect(attributes.cell[cellAttr]).to.not.equal(positions[2]);
                expect($(domPos.node).find(domClass).attr(domAttr)).to.equal(positions[0]);
            });

            it('should have vertical alignment attribute', function () {
                domPos = Position.getDOMPosition(rootNode, [0, 0, 1]);
                attributes = AttributeUtils.getExplicitAttributes(domPos.node);
                expect(attributes.cell[cellAttr]).to.equal(positions[1]);
                expect(attributes.cell[cellAttr]).to.not.equal(positions[2]);
                expect(attributes.cell[cellAttr]).to.not.equal(positions[0]);
                expect($(domPos.node).find(domClass).attr(domAttr)).to.equal(positions[1]);
            });

            it('should have vertical alignment attribute', function () {
                domPos = Position.getDOMPosition(rootNode, [0, 0, 2]);
                attributes = AttributeUtils.getExplicitAttributes(domPos.node);
                expect(attributes.cell[cellAttr]).to.not.equal(positions[0]);
                expect(attributes.cell[cellAttr]).to.not.equal(positions[1]);
                expect(attributes.cell[cellAttr]).to.equal(positions[2]);
                expect($(domPos.node).find(domClass).attr(domAttr)).to.equal(positions[2]);
            });

        });

    });

    // ========================================================================
});
