/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'io.ox/office/spreadsheet/view/render/renderutils'
], function (RenderUtils) {

    'use strict';

    // static class RenderUtils ===============================================

    describe('Spreadsheet module RenderUtils', function () {

        it('should exist', function () {
            expect(RenderUtils).to.be.an('object');
        });

        describe('constant "CANVAS_RESOLUTION"', function () {
            it('should exist', function () {
                expect(RenderUtils).to.have.a.property('CANVAS_RESOLUTION').that.is.a('number').and.is.at.least(1);
            });
        });

        describe('constant "GRID_LINE_WIDTH"', function () {
            it('should exist', function () {
                expect(RenderUtils).to.have.a.property('GRID_LINE_WIDTH').that.is.a('number').and.is.at.most(1);
            });
        });
    });

    // ========================================================================
});
