/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Mario Schroeder <mario.schroeder@open-xchange.com>
 */

/* eslint no-new: 0 */

define('io.ox/office/presenter/mailactions', [
    'io.ox/core/extensions',
    'io.ox/core/extPatterns/actions',
    'io.ox/core/extPatterns/links',
    'io.ox/files/api',
    'io.ox/office/tk/utils/presenterutils',
    'gettext!io.ox/office/presenter/main'

], function (Ext, ActionsPattern, LinksPattern, FilesAPI, PresenterUtils, gt) {

    'use strict';

    // static class MailActions ===============================================

    var MailActions = {};

    var PRESENTER_ACTION_ID = 'io.ox/office/presenter/actions';
    var RE_PGP_ENCRYPTED    = /application\/pgp/i;

    // static private functions ===============================================

    function canPresent(data) {
        // the file model representing the mail attachment
        var model = new FilesAPI.Model(data);
        return ((FilesAPI.isPresentation(data) || FilesAPI.isPDF(data)) && model.isMailAttachment());
    }

    function isPGPAttachment(data) {
        return (!_.isEmpty(data.pgpFormat) || (RE_PGP_ENCRYPTED.test(data.content_type)));
    }

    function appendGuardData(data) {
        if ((data.source !== 'guardMail') || _.isEmpty(data.guardUrl)) {
            // Guard URL params
            var params = '&emailid=' + data.parent.id +
                '&attach=' + data.id +
                '&session=' + ox.session +
                '&userid=' + ox.user_id +
                '&cid=' + ox.context_id +
                '&folder=' + data.parent.folder_id +
                '&attname=' + encodeURIComponent(data.filename);

            if (window.oxguarddata && window.oxguarddata.passcode) {
                params += '&auth=' + encodeURIComponent(window.oxguarddata.passcode);
            }
            if (data.epass) {
                params += '&epassword=' + encodeURIComponent(data.epass);
            }

            data.guardUrl  = ox.apiRoot + '/oxguard/pgpmail/' + encodeURIComponent(data.filename) + '?action=getattach' + params;
            data.source    = 'guardMail';
            data.origData  = data;
            data.folder_id = data.parent.folder_id;
        }

        return data;
    }

    // public methods ---------------------------------------------------------

    // static initialization ==================================================

    new ActionsPattern.Action(PRESENTER_ACTION_ID + '/launchpresenter/mail', {
        capabilities: 'presenter',
        requires: function (e) {
            if (!e.collection.has('one')) {
                return false;
            }

            // e.baton.data can be an object or an array
            var data  = _.isArray(e.baton.data) ? _.first(e.baton.data) : e.baton.data;
            return canPresent(data);
        },
        action: function (baton) {
            // baton.data can be an object or an array
            var data  = _.isArray(baton.data) ? _.first(baton.data) : baton.data;
            // the file model representing the mail attachment
            var model = null;

            if (isPGPAttachment(data)) {
                data = appendGuardData(data);
            }

            model = new FilesAPI.Model(data);
            PresenterUtils.launchPresenter(model);
        }
    });

    var link = {
        id: 'launchpresenter_mail',
        index: 200,
        prio: 'hi',
        mobile: 'lo',
        label: /*#. launch the presenter app */ gt('Present'),
        ref: PRESENTER_ACTION_ID + '/launchpresenter/mail'
    };

    var iconLink = _.extend({}, link, {
        index: 650,
        icon: 'fa fa-play-circle-o'
    });

    // define link for the OX Presenter launch action in OX Mail.
    Ext.point('io.ox/mail/attachment/links').extend(new LinksPattern.Link(link));

    // define link for the OX Presenter launch action in the OX Viewer toolbar.
    Ext.point('io.ox/core/viewer/toolbar/links/mail').extend(new LinksPattern.Link(iconLink));
    Ext.point('io.ox/core/viewer/toolbar/links/guardMail').extend(new LinksPattern.Link(iconLink));

    // exports ================================================================

    return MailActions;

});
