/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author David Bauer <david.bauer@open-xchange.com>
 * @author Julian Bäume <julian.baeume@open-xchange.com>
 */

'use strict';

module.exports = function (grunt) {

    grunt.config.merge({ copy: {
        build_thirdparty: {
            files: [
                {
                    src: ['bootstrap.min.js'],
                    expand: true,
                    cwd: 'node_modules/bootstrap/dist/js',
                    dest: 'build/<%= baseDir %>'
                }, {
                    src: ['jquery.min.js'],
                    expand: true,
                    cwd: 'node_modules/jquery/dist',
                    dest: 'build/<%= baseDir %>'
                }
           ]
        },
        build_help: {
            files: [
                {
                    src: ['**/*'],
                    expand: true,
                    filter: 'isFile',
                    cwd: 'help',
                    dest: 'build/<%= baseDir %>'
                }
            ]
        },
        dist_help: {
            files: [
                {
                    src: ['**/*', '!l10n/**/*'],
                    expand: true,
                    filter: 'isFile',
                    cwd: 'build/<%= baseDir %>',
                    dest: 'dist/appsuite/<%= baseDir %>'
                }
            ]
        },
        local_install_static: {
            files: [
                {
                    src: ['**/*', '!appsuite/<%= baseDir %>/l10n/**/*'],
                    expand: true,
                    filter: 'isFile',
                    cwd: 'dist/',
                    dest: grunt.option('htdoc')
                }
            ]
        }
    }});

    // add dist l10n copy tasks

    grunt.file.expand({
        cwd: 'help/l10n',
        filter: 'isDirectory'
    }, '*').forEach(function (Lang) {
        var lang = Lang.toLowerCase().replace(/_/g, '-'),
            config = {};

        config['dist_help_' + Lang] = {
            files: [
                {
                    src: ['l10n/' + Lang + '/**/*'],
                    expand: true,
                    filter: 'isFile',
                    cwd: 'build/<%= baseDir %>',
                    dest: 'dist/appsuite/<%= baseDir %>'
                }
            ]
        };
        config['local_install_' + Lang] = {
            files: [
                {
                    src: ['appsuite/<%= baseDir %>/l10n/' + Lang + '/**/*'],
                    expand: true,
                    filter: 'isFile',
                    cwd: 'dist/',
                    dest: grunt.option('htdoc')
                }
            ]
        };

        grunt.config.merge({ 'copy': config });
        grunt.registerTask('install:' + Lang, 'install language directory into a custom location', function () {
            if (!grunt.option('htdoc')) {
                grunt.fail.fatal('Need --htdoc option to be set');
            }
            grunt.log.writeln('Installing into:', grunt.option('htdoc'));
            grunt.task.run('copy:local_install_' + Lang);
        });
    });
    grunt.loadNpmTasks('grunt-contrib-copy');
};
