/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'io.ox/office/editframework/utils/operationerror'
], function (OperationError) {

    'use strict';

    // class OperationError ===================================================

    describe('EditFramework class OperationError', function () {

        it('should exist', function () {
            expect(OperationError).to.be.a('function');
        });

        // constructor --------------------------------------------------------

        describe('constructor', function () {
            it('should create an error instance', function () {
                var op = {}, error = new OperationError('bad', op);
                expect(error).to.be.an.instanceof(OperationError);
                expect(error).to.be.an.instanceof(Error);
                expect(error).to.have.a.property('name', 'OperationError');
                expect(error).to.have.a.property('message', 'bad');
                expect(error).to.have.a.property('operation', op);
            });
        });
    });

    // ========================================================================
});
