// Karma configuration
// Generated on Fri Apr 11 2014 11:05:09 GMT+0200 (CEST)

/* eslint-env node */

module.exports = function (config) {

    'use strict';

    // define the list of files used for the test run.
    // note : f you get something like "mtime is undefined" on the command line ...
    // it means that one of the search pattern do not result within a real file list ...
    // and karma calls "files.search(pattern).mtime" ...
    // So it's up to you to define right pattern here ;-)
    var files4Test = [
        '../node_modules/underscore/underscore.js',
        '../node_modules/jquery/dist/jquery.js',
        'spec/lib/**/*.js',
        { pattern: 'apps/**/*.@(js|json)', included: false }, // included false means : included in search path ... but excluded from 'execution' path
        { pattern: 'spec/globals/**/*.js', included: false },
        { pattern: 'spec/**/*_spec.js', included: false }
    ];

    // HACK : global.TEST_MODULE is define within grunt task 'karma.js' !
    if (global.TEST_MODULE !== undefined && global.TEST_MODULE !== null) {
        files4Test.push('spec/test-' + global.TEST_MODULE + '.js');
    } else {
        files4Test.push('spec/test-all.js');
    }

    // possible values: config.LOG_DISABLE || config.LOG_ERROR || config.LOG_WARN || config.LOG_INFO || config.LOG_DEBUG
    var karmaLogLevel = config.LOG_ERROR;

    if (global.LOG_LEVEL !== undefined && global.LOG_LEVEL !== null) {
        if (global.LOG_LEVEL === 'debug') {
            karmaLogLevel = config.LOG_DEBUG;
        } else if (global.LOG_LEVEL === 'info') {
            karmaLogLevel = config.LOG_INFO;
        } else if (global.LOG_LEVEL === 'warn') {
            karmaLogLevel = config.LOG_WARN;
        } else {
            karmaLogLevel = config.LOG_ERROR;
        }
    }

    config.set({

        // base path that will be used to resolve all patterns (eg. files, exclude)
        basePath: 'build/',
        builddir: 'build/',

        browserNoActivityTimeout: 50000, // default: 10000

        // frameworks to use
        // available frameworks: https://npmjs.org/browse/keyword/karma-adapter
        frameworks: ['mocha', 'requirejs', 'chai', 'sinon'],

        // list of files / patterns to load in the browser
        files: files4Test,

        // list of files to exclude
        exclude: [
        ],

        // preprocess matching files before serving them to the browser
        // available preprocessors: https://npmjs.org/browse/keyword/karma-preprocessor
        preprocessors: {
        },

        // test results reporter to use
        // possible values: 'dots', 'progress', 'junit', 'growl', 'coverage'
        // available reporters: https://npmjs.org/browse/keyword/karma-reporter
        reporters: ['progress'],

        // web server port
        port: 9876,

        // enable / disable colors in the output (reporters and logs)
        colors: true,

        // level of logging
        logLevel: karmaLogLevel,

        // enable / disable watching file and executing tests whenever any file changes
        autoWatch: false,

        // start these browsers
        // available browser launchers: https://npmjs.org/browse/keyword/karma-launcher
        browsers: ['PhantomJS'],

        // Continuous Integration mode
        // if true, Karma captures browsers, runs the tests and exits
        singleRun: false
    });
};
