/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author York Richter <york.richter@open-xchange.com>
 */

define('io.ox/office/spreadsheet/view/dialog/unhidesheetsdialog', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/utils/iterator',
    'io.ox/office/tk/control/checkgroup',
    'io.ox/office/tk/dialog/basedialog',
    'gettext!io.ox/office/spreadsheet/main'
], function (Utils, Iterator, CheckGroup, BaseDialog, gt) {

    'use strict';

    // class UnhideSheetsDialog ===============================================

    /**
     * A dialog that allows to make some or all hidden sheets visible in the
     * spreadsheet document.
     *
     * @constructor
     *
     * @extends BaseDialog
     *
     * @param {SpreadsheetView} docView
     *  The spreadsheet view instance that has created this dialog.
     */
    var UnhideSheetsDialog = BaseDialog.extend(function (docView) {

        // base constructor
        BaseDialog.call(this, docView, { width: 400, title: gt('Unhide Sheets') });

        // list of checkboxes for all hidden sheets
        var checkGroup = new CheckGroup(docView, { boxed: true, checkAll: true, classes: 'list-design' });

        // close dialog automatically after losing edit rights
        docView.closeDialogOnReadOnlyMode(this);

        // create the list of check boxes
        this.append(checkGroup.getNode());
        var iterator = docView.getDocModel().createSheetIterator({ supported: true, visible: false });
        Iterator.forEach(iterator, function (sheetModel, iterResult) {
            var sheetLabel = _.noI18n(iterResult.name);
            checkGroup.createOptionButton(iterResult.sheet, { label: sheetLabel, attributes: { role: 'checkbox' } });
        });

        // update enabled state of the OK button
        this.addOkValidator(function () { return checkGroup.getValue().length > 0; });
        this.validateOn(checkGroup, 'group:change');

        // return the dialog result
        this.setOkHandler(function () { return checkGroup.getValue(); });

        // destroy class members
        this.registerDestructor(function () {
            checkGroup.destroy();
            docView = checkGroup = null;
        });

    }); // class UnhideSheetsDialog

    // exports ================================================================

    return UnhideSheetsDialog;

});
