/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/settings/register', [

    'io.ox/core/extensions',
    'io.ox/core/manifests',

    'io.ox/office/tk/io',
    'io.ox/office/tk/utils/scheduler',
    'io.ox/office/tk/utils/driveutils',

    'io.ox/office/settings/templatefolders',
    'io.ox/office/settings/templatemodel',
    'io.ox/office/settings/contexttemplatemodel',
    'io.ox/office/settings/view/settingslabels',
    'io.ox/office/settings/units',
    'io.ox/office/settings/spellchecking',
    'io.ox/office/settings/userdictionary',
    'io.ox/office/settings/spellchecklanguagenotification',

    'io.ox/office/tk/forms'

], function (ext, Manifests, IO, Scheduler, DriveUtils, TemplateFolders, TemplateModel, ContextTemplateModel, Labels, Units, SpellChecking, UserDictionary, SpellcheckNotification, Forms) {

    'use strict';

    var inited = false;

    var Register = {};

    Register.init = function () {
        if (inited) {
            return;
        }

        inited = true;

        //extend the global settings with office settings
        ext.point('io.ox/settings/pane/main').extend({
            id: 'io.ox/office',
            title: Labels.DOCUMENTS_HEADER_LABEL,
            ref: 'io.ox/office',
            loadSettingPane: false,
            index: 4000
        });

        var settingsObject = {};
        var settingsNode = null;
        var section = null;
        var subSettings = [];
        var checkAdminProm = null;

        subSettings.push(new Units());
                                                            // spell-check section with ...
        subSettings.push(new SpellChecking());              // - enable/disable spell-checking.
        subSettings.push(new UserDictionary());             // - open edit dialog that is specific to user dictionary.
        subSettings.push(new SpellcheckNotification());     // - open edit dialog that is specific to how to handle spell-check language notification.
                                                            // see comments section and attachments of DOCS-630 - [https://jira.open-xchange.com/browse/DOCS-630]
        if (!DriveUtils.isGuest()) {

            subSettings.push(new TemplateFolders(new TemplateModel('MyTemplateFolders'), { title: Labels.USER_TEMPLATE_FOLDER, useMyFiles: true }));

            checkAdminProm = checkAdmin();

            checkAdminProm.always(function () {
                var resolved = checkAdminProm.state() === 'resolved';
                var model = null;

                var init = function () {
                    subSettings.push(new TemplateFolders(model, { title: Labels.GLOBAL_TEMPLATE_FOLDER, readOnly: !resolved, showReadAccess: resolved }));
                };

                if (resolved) {
                    model = new TemplateModel('ContextTemplateFolders');
                    init();
                } else {
                    IO.sendRequest(IO.FILTER_MODULE_NAME, { action: 'getcontexttemplatefolders' }).done(function (data) {
                        model = new ContextTemplateModel(data);
                        init();
                    });
                }
            });
        }

        /**
         * standard options section-title
         */
        settingsObject.appendTitle = function (title) {
            var tt = $('<legend class="sectiontitle">');
            tt.text(title);
            section.append(tt);
            return tt;
        };

        /**
         * standard dialog button
         */
        settingsObject.appendButton = function (title, listener) {
            var btn = $('<button type="button" class="btn btn-primary" tabindex="0">');
            btn.text(title).on('click', listener);
            section.append(btn);
            return btn;
        };

        /**
         * standard dialog checkbox
         */
        settingsObject.appendCheckbox = function (labelCopy, checkboxName, isChecked, listener) {
            var checkboxMarkup = Forms.createButtonMarkup({ attributes: { class: checkboxName, role: 'checkbox' }, label: labelCopy }),
                $checkbox = $(checkboxMarkup);

            section.append($checkbox);

            Forms.checkButtonNodes($checkbox, isChecked, { design: 'boxed', ambiguous: false });
            Forms.setButtonKeyHandler($checkbox);
            $checkbox.on('click', function () {
                var state = !$checkbox.find('i').hasClass('checked');
                Forms.checkButtonNodes($checkbox, state, { design: 'boxed', ambiguous: false });
                listener(state);
            });

            return $checkbox;
        };

        settingsObject.newSection = function () {
            section = $('<fieldset>');
            settingsNode.append(section);
        };

        settingsObject.append = function (node) {
            section.append(node);
        };

        var first = true;

        var innerDraw = function () {

            settingsNode = this;

            settingsNode.empty();
            settingsNode.append($('<h1>').text(Labels.DOCUMENTS_HEADER_LABEL));

            _.each(subSettings, function (subSetting) {
                if (subSetting.newSection()) {
                    settingsObject.newSection();
                } else {
                    settingsObject.append($('<div style="display: block; height: 0; margin-bottom: 20px">'));

                }
                subSetting.refresh(settingsObject);
            });

            if (first) {
                first = false;
                var settingsWindow = ox.ui.windowManager.getWindows().filter(function (win) { return win.name === 'io.ox/settings'; })[0];

                var thizz = this;

                var refresh = function () {
                    settingsWindow.app.folder.getData().done(function (model) {
                        if (model.id === 'virtual/settings/io.ox/office') {
                            innerDraw.apply(thizz, arguments);
                        }
                    });
                };

                ox.on('refresh^', refresh);
                settingsWindow.on('beforeshow', refresh);
            }
        };

        function checkAdmin() {
            var resp = $.ajax('/ajax/user/me?session=' + ox.session, {
                type: 'GET',
                dataType: 'json'
            });
            var ret = Scheduler.createDeferred('io-ox-office-settings', 'Register.checkAdmin');
            resp.done(function (answer) {
                if (answer.data.user_id && answer.data.user_id === answer.data.context_admin) {
                    ret.resolve();
                } else {
                    ret.reject();
                }
            });
            resp.fail(ret.reject);
            return ret;
        }

        //office settings
        ext.point('io.ox/office/settings/detail').extend({
            index: 100,
            draw: innerDraw
        });

    };

    return Register;
});
