/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/view/dialog/saveastemplatedialog', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/io',
    'io.ox/office/tk/utils/driveutils',
    'io.ox/office/tk/dialog/saveasdialog',
    'io.ox/office/settings/templatemodel',
    'io.ox/office/settings/contexttemplatemodel',
    'io.ox/office/editframework/view/editlabels'
], function (Utils, IO, DriveUtils, SaveAsDialog, TemplateModel, ContextTemplateModel, Labels) {

    'use strict';

    // settings key for the last used folder
    var RECENT_FOLDER_KEY = 'recentSaveAsTemplate';

    // private global functions ===============================================

    function getRecentFolderId(docView) {
        return docView.getApp().getUserSettingsValue(RECENT_FOLDER_KEY, DriveUtils.getStandardTemplateFolderId());
    }

    function setRecentFolderId(docView, folderId) {
        if (folderId) { docView.getApp().setUserSettingsValue(RECENT_FOLDER_KEY, folderId); }
    }

    // class SaveAsTemplateDialog =============================================

    /**
     * @constructor
     *
     * @extends SaveAsDialog
     *
     * @param {EditView} docView
     *  The document view instance that has created this dialog.
     *
     * @param {String} title
     *  The title of the dialog.
     *
     * @param {String} fileName
     *  The initial file name to be shown in the text edit control.
     */
    var SaveAsTemplateDialog = SaveAsDialog.extend(function (docView, title, fileName) {

        // base constructor
        SaveAsDialog.call(this, docView, {
            title: title,
            value: fileName,
            folderId: getRecentFolderId(docView),
            flatPicker: true
        });

        var folderPicker = this.getFolderPicker();
        var myFolders = [DriveUtils.getStandardTemplateFolderId()];
        myFolders = myFolders.concat(new TemplateModel('MyTemplateFolders').getAll());
        myFolders = _.unique(myFolders);
        folderPicker.addFolders(Labels.USER_TEMPLATE_FOLDER, myFolders);

        IO.sendRequest(IO.FILTER_MODULE_NAME, { action: 'getcontexttemplatefolders' }).done(function (data) {
            folderPicker.addFolders(Labels.GLOBAL_TEMPLATE_FOLDER, new ContextTemplateModel(data).getAll());
        });

        this.setOkHandler(function () {
            var folderId = this.getFolderId();
            setRecentFolderId(docView, folderId);
            return { folderId: folderId, fileName: this.getFileName() };
        });

    }); // class SaveAsTemplateDialog

    // exports ================================================================

    return SaveAsTemplateDialog;

});
