/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/utils/operations', [
    'io.ox/office/drawinglayer/utils/operations'
], function (DrawingOperations) {

    'use strict';

    // static class BaseOperations ============================================

    var BaseOperations = {};

    // static methods ---------------------------------------------------------

    BaseOperations.extend = function () {
        var operations = _.clone(this);
        _.each(arguments, function (constants) {
            _.extend(operations, constants);
        });
        return operations;
    };

    // static class EditOperations ============================================

    /**
     * Provides constants for the names of generic document operations.
     *
     * @extends DrawingOperations
     */
    var EditOperations = BaseOperations.extend(DrawingOperations, {

        /**
         * Name of the initial operation while importing a document, sets
         * global attributes of the model, including default formatting
         * attributes.
         *
         * @constant
         */
        SET_DOCUMENT_ATTRIBUTES: 'setDocumentAttributes',

        /**
         * Name of the operation that inserts a new theme into the theme
         * collection.
         *
         * @constant
         */
        INSERT_THEME: 'insertTheme',

        /**
         * Name of the operation that inserts a new font description into the
         * font collection.
         *
         * @constant
         */
        INSERT_FONT_DESCRIPTION: 'insertFontDescription',

        /**
         * Name of the operation that inserts a new style sheet into the
         * document.
         *
         * @constant
         */
        INSERT_STYLESHEET: 'insertStyleSheet',

        /**
         * Name of the operation that removes an existing style sheet from the
         * document.
         *
         * @constant
         */
        DELETE_STYLESHEET: 'deleteStyleSheet',

        /**
         * Name of the operation that changes the properties of an existing
         * style sheet in the document.
         *
         * @constant
         */
        CHANGE_STYLESHEET: 'changeStyleSheet',

        /**
         * Name of the operation that inserts a new auto-style into the
         * document.
         *
         * @constant
         */
        INSERT_AUTOSTYLE: 'insertAutoStyle',

        /**
         * Name of the operation that changes the formatting attributes of an
         * existing auto-style in the document.
         *
         * @constant
         */
        CHANGE_AUTOSTYLE: 'changeAutoStyle',

        /**
         * Name of the operation that deletes an existing auto-style from the
         * document.
         *
         * @constant
         */
        DELETE_AUTOSTYLE: 'deleteAutoStyle',

        /**
         * Name of the operation that does nothing (internal usage).
         *
         * @constant
         */
        NOOP: 'noOp'

    });

    // exports ================================================================

    return EditOperations;

});
