/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/drawinglayer/view/dialog/insertimageurldialog', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/dialog/basedialog',
    'io.ox/office/drawinglayer/utils/imageutils',
    'gettext!io.ox/office/drawinglayer/main'
], function (Utils, BaseDialog, ImageUtils, gt) {

    'use strict';

    // class InsertImageURLDialog =============================================

    /**
     * A dialog that provides a URL text field for a new image to be inserted
     * into the document.
     *
     * @constructor
     *
     * @extends BaseDialog
     *
     * @param {EditView} docView
     *  The document view that is creating the dialog.
     */
    var InsertImageURLDialog = BaseDialog.extend(function (docView) {

        // base constructor
        BaseDialog.call(this, docView, {
            title: gt('Insert Image URL'),
            width: 800
        });

        // the "Enter URL" widget
        var urlInput = $('<input class="form-control" tabindex="0" role="textbox">', {
            'aria-label': gt('Enter image URL')
        });

        function getUrl() {
            return urlInput.val().trim();
        }

        // bug 43868: iOS auto correction should be off for input fields
        // TODO: use Forms.createInputMarkup() to create inputs here, it already has this fix
        if (Utils.IOS) {
            urlInput.attr({ autocorrect: 'off', autocapitalize: 'none' });
        }

        this.append(urlInput);
        this.setFocusNode(urlInput);

        // close dialog automatically after losing edit rights
        docView.closeDialogOnReadOnlyMode(this);

        // create a validator for the URL input field
        this.addOkValidator(function () {
            return docView.getApp().isEditable() && (getUrl().length > 0);
        });
        this.validateOn(urlInput, 'input');

        // handler for the OK button of the dialog
        this.setOkHandler(function () {
            return ImageUtils.insertURL(getUrl());
        });

    }); // class InsertImageURLDialog

    // exports ================================================================

    return InsertImageURLDialog;

});
