/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author York Richter <york.richter@open-xchange.com>
 */

define([
    'globals/apphelper',
    'io.ox/office/text/model/updatedocumentmixin',
    'io.ox/office/textframework/utils/textutils',
    'io.ox/office/textframework/utils/config'
], function (AppHelper, UpdateDocumentMixin, TextUtils, TextConfig) {

    'use strict';

    // class UpdateDocumentMixin ==================================================

    describe('Text mix-in class UpdateDocumentMixin', function () {

        it('should exist', function () {
            expect(UpdateDocumentMixin).to.be.a('function');
        });
    });

    var OPERATIONS = [
        { name: 'setDocumentAttributes',
            attrs: {
                document:  { defaultTabStop: 1270, zoom: { value: 100 } },
                page:      { width: 21590, height: 27940, marginLeft: 2540, marginTop: 2540, marginRight: 2540, marginBottom: 2540, marginHeader: 1248, marginFooter: 0 },
                character: { fontName: 'Arial', fontSize: 11, language: 'en-US', languageEa: 'en-US', languageBidi: 'ar-SA' },
                paragraph: { lineHeight: { type: 'percent', value: 115 }, marginBottom: 352 }
            }
        },
        { name: 'insertStyleSheet', type: 'paragraph', styleId: 'Heading1', styleName: 'heading 1',
            attrs: {
                character: { bold: true, fontName: 'Times New Roman', fontSize: 14, color: { transformations: [{ type: 'shade', value: 74902 }], type: 'scheme', value: 'accent1' } },
                paragraph: { marginTop: 846, outlineLevel: 0, nextStyleId: 'Normal' }
            },
            parent: 'Normal',
            uiPriority: 9
        },
        { name: 'insertParagraph', start: [0] },
        { name: 'insertText', text: 'Hello World', start: [0, 0] }
    ];

    function testTextLocale(locale, width, height) {
        describe('Test ' + locale + ' OXText', function () {
            var docModel = null, oldLocale = null;
            before(function () { oldLocale = TextConfig.LOCALE; TextConfig.LOCALE = locale; });
            AppHelper.createTextApp('ooxml', OPERATIONS).done(function (app) {
                docModel = app.getModel();
            });
            it('Test paper format', function () {
                var page = docModel.getPageStyles().getElementAttributes(docModel.getNode()).page;
                expect(page.width).to.equal(width);
                expect(page.height).to.equal(height);
            });
            after(function () { TextConfig.LOCALE = oldLocale; });
        });
    }

    _.keys(TextUtils.DEFAULT_PAPER_FORMAT).forEach(function (locale) {
        var papersize = TextUtils.getPaperSizeByLocale(locale);
        testTextLocale(locale, papersize.width, papersize.height);
    });
});
