/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

define([
    'globals/apphelper',
    'io.ox/office/editframework/model/stylecollection'
], function (AppHelper, StyleCollection) {

    'use strict';

    // class StyleCollection ==================================================

    describe('EditFramework class StyleCollection', function () {

        it('should exist', function () {
            expect(StyleCollection).to.be.a('function');
        });

        // private helpers ----------------------------------------------------

        // dummy attribute definitions for three families
        var A_ATTRS = { attrA1: { def: 'a1' }, attrA2: { def: 'a2' } };
        var B_ATTRS = { attrA1: { def: 'b1' }, attrA2: { def: 'b2' } };
        var C_ATTRS = { attrA1: { def: 'b1' }, attrA2: { def: 'c2' } };

        // initialize an edit application with style sheets
        var docModel = null, styleSheets = null;
        AppHelper.createEditApp('ooxml').done(function (app) {
            docModel = app.getModel();
            docModel.registerAttributes('A', A_ATTRS);
            docModel.registerAttributes('B', B_ATTRS);
            docModel.registerAttributes('C', C_ATTRS);
            docModel.addStyleCollection(styleSheets = new StyleCollection(docModel, 'A', { families: 'B C' }));
        });

        // public methods -----------------------------------------------------

        describe('method "applyInsertStyleSheetOperation"', function () {
            it('should exist', function () {
                expect(styleSheets).to.respondTo('applyInsertStyleSheetOperation');
            });
        });

        describe('method "applyDeleteStyleSheetOperation"', function () {
            it('should exist', function () {
                expect(styleSheets).to.respondTo('applyDeleteStyleSheetOperation');
            });
        });

        describe('method "applyChangeStyleSheetOperation"', function () {
            it('should exist', function () {
                expect(styleSheets).to.respondTo('applyChangeStyleSheetOperation');
            });
        });
    });

    // ========================================================================
});
